package com.elitesland.support.provider.org.dto;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import lombok.Data;


/**
 * 功能说明 实体类:OrgStoreLicense
 *
 * @author meng
 * @date 2024-03-19 10:37:21
 */

@Data
@ApiModel("门店证件")
public class OrgStoreWhDTO implements Serializable {
private static final long serialVersionUID =1529198213519862979L;



	/**
	 * 仓库类型
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "仓库类型")
	@SysCode(sys = "yst-supp", mod = "STORE_WH_TYPE")
	private Integer whType;

	@ApiModelProperty(value = "仓库类型")
	private String whTypeName;


	/**
	 * 仓库编码
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "仓库编码")
	private String whCode;

	private Long storeId;

	private String storeCode;


	/**
	 * 仓库名称
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "仓库名称")
	private String whName;

	/**
	 * 仓库优先级
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "仓库优先级")
	private Integer whLevel;

	/**
	 * 仓库映射比例
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "仓库映射比例")
	private BigDecimal whScale;

	@ApiModelProperty(value = "仓库总映射比例")
	private BigDecimal whSumScale;



	/**
	 * 日可承诺单量
	 * nullable : false
	 * default  : null
	 */
	@ApiModelProperty(value = "日可承诺单量")
	private BigDecimal dayQty;


}
