/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.support.provider.flexField.service;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.core.support.customfield.common.CustomFieldAbstractVo;
import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModelVo;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.support.provider.flexField.dto.FlexFieldShowNamesRpcDTO;
import com.elitesland.support.provider.flexField.dto.FlexFieldStructDRpcDTO;
import com.elitesland.support.provider.flexField.dto.FlexFieldValueRpcDTO;
import com.elitesland.support.provider.flexField.dto.ObjectFlexFieldValueRpcDTO;
import com.elitesland.support.provider.flexField.param.FlexFieldReferenceValueQueryRpcParam;
import com.elitesland.support.provider.flexField.param.FlexFieldShowNamesQueryRpcParam;
import com.elitesland.support.provider.flexField.param.FlexFieldStructDQueryRpcParam;
import com.elitesland.support.provider.flexField.param.FlexFieldValueQueryRpcNewParam;
import com.elitesland.support.provider.flexField.param.FlexFieldValueQueryRpcParam;
import com.elitesland.support.provider.flexField.param.ListFlexFieldValueQueryRpcParam;
import com.elitesland.support.provider.flexField.param.ObjectFlexFieldValueQueryRpcParam;
import com.elitesland.support.provider.flexField.service.FlexFieldRpcService;
import com.elitesland.support.provider.flexField.service.FlexFieldUtilService;
import io.reactivex.rxjava3.functions.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FlexFieldUtilServiceImpl
implements FlexFieldUtilService {
    private static final Logger log = LoggerFactory.getLogger(FlexFieldUtilServiceImpl.class);
    @Autowired
    private FlexFieldRpcService flexFieldRpcService;
    @Autowired
    private RedisUtils redisUtils;

    @Override
    public Map<String, String> handFlexFieldValueFeference(String flexFieldCode, Map<String, String> flexFieldWhereClauseMap, Map<String, String> extensionInfo) {
        List referFlexFields;
        log.info("\u5904\u7406\u503c\u4f20\u9012\uff0c\u53c2\u6570\uff0cflexFieldCode\uff1a{}\uff0cflexFieldWhereClauseMap\uff1a{}\uff0cextensionInfo\uff1a{}", new Object[]{flexFieldCode, JSON.toJSONString(flexFieldWhereClauseMap), JSON.toJSONString(extensionInfo)});
        if (StringUtils.isBlank((CharSequence)flexFieldCode)) {
            throw new BusinessException("\u5904\u7406\u503c\u4f20\u9012\u5f15\u7528\uff0c\u5f39\u6027\u57df\u7f16\u7801\u4e3a\u7a7a");
        }
        HashMap<Object, Object> newExtensionInfo = new HashMap();
        newExtensionInfo = extensionInfo == null ? new HashMap() : new HashMap<String, String>(extensionInfo);
        FlexFieldStructDQueryRpcParam flexFieldStructDQueryRpcParam = new FlexFieldStructDQueryRpcParam();
        flexFieldStructDQueryRpcParam.setFlexFieldCode(flexFieldCode);
        ApiResult<List<FlexFieldStructDRpcDTO>> flexFieldStructDList = this.flexFieldRpcService.queryFlexFieldStructDS(flexFieldStructDQueryRpcParam);
        log.info("\u5904\u7406\u503c\u4f20\u9012\uff0c\u5f39\u6027\u57df\uff1a{}\uff0crpc\u67e5\u8be2\u5b57\u6bb5\u914d\u7f6e\u7ed3\u679c\uff1a{}", (Object)flexFieldCode, (Object)JSON.toJSONString(flexFieldStructDList));
        if (CollectionUtils.isNotEmpty((Collection)((Collection)flexFieldStructDList.getData())) && CollectionUtils.isNotEmpty(referFlexFields = ((List)flexFieldStructDList.getData()).stream().filter(v -> "FLEX_FIELD".equals(v.getSourceType())).collect(Collectors.toList()))) {
            List<FlexFieldValueQueryRpcParam> flexFieldValueQueryRpcParams = referFlexFields.stream().map(v -> {
                FlexFieldValueQueryRpcParam flexFieldValueQueryRpcParam = new FlexFieldValueQueryRpcParam();
                flexFieldValueQueryRpcParam.setFlexField(v.getFlexField());
                flexFieldValueQueryRpcParam.setWhereClause((String)flexFieldWhereClauseMap.get(v.getFlexField()));
                return flexFieldValueQueryRpcParam;
            }).collect(Collectors.toList());
            FlexFieldValueQueryRpcNewParam flexFieldValueQueryRpcNewParam = new FlexFieldValueQueryRpcNewParam();
            flexFieldValueQueryRpcNewParam.setFlexFieldCode(flexFieldCode);
            flexFieldValueQueryRpcNewParam.setFlexFieldValueQueryRpcParams(flexFieldValueQueryRpcParams);
            ApiResult<Map<String, FlexFieldValueRpcDTO>> apiResult = this.flexFieldRpcService.queryFlexFieldValuesNew(flexFieldValueQueryRpcNewParam);
            Map flexFieldValueMap = (Map)apiResult.getData();
            if (flexFieldValueMap != null && !flexFieldValueMap.isEmpty()) {
                for (Map.Entry flexFieldValueEntry : flexFieldValueMap.entrySet()) {
                    newExtensionInfo.put((String)flexFieldValueEntry.getKey(), flexFieldValueEntry.getValue() != null ? ((FlexFieldValueRpcDTO)flexFieldValueEntry.getValue()).getFlexFieldValue().toString() : "");
                }
            }
        }
        if (newExtensionInfo.isEmpty()) {
            return null;
        }
        extensionInfo = newExtensionInfo;
        return newExtensionInfo;
    }

    @Override
    public Map<String, String> handFlexFieldValueFeference(String flexFieldCode, Object obj, Map<String, String> extensionInfo) {
        List referFlexFields;
        log.info("\u5904\u7406\u503c\u4f20\u9012\uff0c\u53c2\u6570\uff0cflexFieldCode\uff1a{}\uff0cobj\uff1a{}\uff0cextensionInfo\uff1a{}", new Object[]{flexFieldCode, JSON.toJSONString((Object)obj), JSON.toJSONString(extensionInfo)});
        if (StringUtils.isBlank((CharSequence)flexFieldCode)) {
            throw new BusinessException("\u5904\u7406\u503c\u4f20\u9012\u5f15\u7528\uff0c\u5f39\u6027\u57df\u7f16\u7801\u4e3a\u7a7a");
        }
        if (obj == null) {
            return extensionInfo;
        }
        if (extensionInfo == null) {
            extensionInfo = new HashMap<String, String>();
        }
        Map objectMap = BeanUtil.beanToMap((Object)obj, (String[])new String[0]);
        FlexFieldStructDQueryRpcParam flexFieldStructDQueryRpcParam = new FlexFieldStructDQueryRpcParam();
        flexFieldStructDQueryRpcParam.setFlexFieldCode(flexFieldCode);
        ApiResult<List<FlexFieldStructDRpcDTO>> flexFieldStructDList = this.flexFieldRpcService.queryFlexFieldStructDS(flexFieldStructDQueryRpcParam);
        log.info("\u5904\u7406\u503c\u4f20\u9012\uff0c\u5f39\u6027\u57df\uff1a{}\uff0crpc\u67e5\u8be2\u5b57\u6bb5\u914d\u7f6e\u7ed3\u679c\uff1a{}", (Object)flexFieldCode, (Object)JSON.toJSONString(flexFieldStructDList));
        if (CollectionUtils.isNotEmpty((Collection)((Collection)flexFieldStructDList.getData())) && CollectionUtils.isNotEmpty(referFlexFields = ((List)flexFieldStructDList.getData()).stream().filter(v -> "FLEX_FIELD".equals(v.getSourceType())).collect(Collectors.toList()))) {
            List<FlexFieldValueQueryRpcParam> flexFieldValueQueryRpcParams = referFlexFields.stream().map(v -> {
                FlexFieldValueQueryRpcParam flexFieldValueQueryRpcParam = new FlexFieldValueQueryRpcParam();
                flexFieldValueQueryRpcParam.setFlexField(v.getFlexField());
                String referSqlCondition = v.getReferSqlCondition();
                if (obj != null) {
                    referSqlCondition = this.handleSqlCondition(referSqlCondition, objectMap);
                }
                flexFieldValueQueryRpcParam.setWhereClause(referSqlCondition);
                return flexFieldValueQueryRpcParam;
            }).collect(Collectors.toList());
            FlexFieldValueQueryRpcNewParam flexFieldValueQueryRpcNewParam = new FlexFieldValueQueryRpcNewParam();
            flexFieldValueQueryRpcNewParam.setFlexFieldCode(flexFieldCode);
            flexFieldValueQueryRpcNewParam.setFlexFieldValueQueryRpcParams(flexFieldValueQueryRpcParams);
            ApiResult<Map<String, FlexFieldValueRpcDTO>> apiResult = this.flexFieldRpcService.queryFlexFieldValuesNew(flexFieldValueQueryRpcNewParam);
            Map flexFieldValueMap = (Map)apiResult.getData();
            if (flexFieldValueMap != null && !flexFieldValueMap.isEmpty()) {
                for (Map.Entry flexFieldValueEntry : flexFieldValueMap.entrySet()) {
                    extensionInfo.put((String)flexFieldValueEntry.getKey(), flexFieldValueEntry.getValue() != null ? ((FlexFieldValueRpcDTO)flexFieldValueEntry.getValue()).getFlexFieldValue().toString() : "");
                }
            }
        }
        if (extensionInfo.isEmpty()) {
            return null;
        }
        return extensionInfo;
    }

    @Override
    public Map<String, String> handFlexFieldValueFeference(String flexFieldCode, Object obj) {
        log.info("\u5904\u7406\u503c\u4f20\u9012\uff0c\u53c2\u6570\uff0cflexFieldCode\uff1a{}\uff0cobj\uff1a{}", (Object)flexFieldCode, (Object)JSON.toJSONString((Object)obj));
        if (StringUtils.isBlank((CharSequence)flexFieldCode)) {
            throw new BusinessException("\u5904\u7406\u503c\u4f20\u9012\u5f15\u7528\uff0c\u5f39\u6027\u57df\u7f16\u7801\u4e3a\u7a7a");
        }
        Object o = this.redisUtils.get("FLEX_FIELD_STATUS:" + flexFieldCode);
        if (!"ACTIVE".equals(o)) {
            log.info("\u5904\u7406\u503c\u4f20\u9012\uff0c\u5f53\u524d\u5f39\u6027\u57df\u672a\u542f\u7528\uff0cflexFieldCode\uff1a{}", (Object)flexFieldCode);
            return null;
        }
        if (obj == null) {
            return null;
        }
        Map objectMap = BeanUtil.beanToMap((Object)obj, (String[])new String[0]);
        HashMap<String, String> extensionInfo = null;
        if (!objectMap.containsKey("extensionInfo")) {
            throw new BusinessException("\u5904\u7406\u503c\u4f20\u9012\u5f15\u7528\uff0c\u76ee\u6807\u5bf9\u8c61\u4e0d\u5305\u542bextensionInfo\u5c5e\u6027");
        }
        extensionInfo = (HashMap<String, String>)objectMap.get("extensionInfo");
        if (extensionInfo == null) {
            extensionInfo = new HashMap<String, String>();
            BeanUtil.setFieldValue((Object)obj, (String)"extensionInfo", extensionInfo);
        }
        FlexFieldReferenceValueQueryRpcParam flexFieldReferenceValueQueryRpcParam = new FlexFieldReferenceValueQueryRpcParam();
        flexFieldReferenceValueQueryRpcParam.setArg(objectMap);
        flexFieldReferenceValueQueryRpcParam.setFlexFieldCode(flexFieldCode);
        ApiResult<Map<String, String>> result = this.flexFieldRpcService.queryFlexFieldFeferenceValueNew(flexFieldReferenceValueQueryRpcParam);
        if (result.isSuccess() && result.getData() != null && !((Map)result.getData()).isEmpty()) {
            extensionInfo.putAll((Map)result.getData());
        }
        return extensionInfo;
    }

    @Override
    public <T> void handFlexFieldValueFeferenceList(String flexFieldCode, List<T> objs) {
        List referFlexFields;
        log.info("\u5904\u7406\u503c\u4f20\u9012\uff0c\u53c2\u6570\uff0cflexFieldCode\uff1a{}\uff0cobj\uff1a{}", (Object)flexFieldCode, (Object)JSON.toJSONString(objs));
        if (StringUtils.isBlank((CharSequence)flexFieldCode)) {
            throw new BusinessException("\u5904\u7406\u503c\u4f20\u9012\u5f15\u7528\uff0c\u5f39\u6027\u57df\u7f16\u7801\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(objs)) {
            return;
        }
        Object flexFieldState = this.redisUtils.get("FLEX_FIELD_STATUS:" + flexFieldCode);
        if (!"ACTIVE".equals(flexFieldState)) {
            log.info("\u5904\u7406\u503c\u4f20\u9012\uff0c\u5f53\u524d\u5f39\u6027\u57df\u672a\u542f\u7528\uff0cflexFieldCode\uff1a{}", (Object)flexFieldCode);
            return;
        }
        FlexFieldStructDQueryRpcParam flexFieldStructDQueryRpcParam = new FlexFieldStructDQueryRpcParam();
        flexFieldStructDQueryRpcParam.setFlexFieldCode(flexFieldCode);
        ApiResult<List<FlexFieldStructDRpcDTO>> flexFieldStructDList = this.flexFieldRpcService.queryFlexFieldStructDS(flexFieldStructDQueryRpcParam);
        log.info("\u5904\u7406\u503c\u4f20\u9012\uff0c\u5f39\u6027\u57df\uff1a{}\uff0crpc\u67e5\u8be2\u5b57\u6bb5\u914d\u7f6e\u7ed3\u679c\uff1a{}", (Object)flexFieldCode, (Object)JSON.toJSONString(flexFieldStructDList));
        if (CollectionUtils.isNotEmpty((Collection)((Collection)flexFieldStructDList.getData())) && CollectionUtils.isNotEmpty(referFlexFields = ((List)flexFieldStructDList.getData()).stream().filter(v -> "FLEX_FIELD".equals(v.getSourceType())).collect(Collectors.toList()))) {
            HashMap objExtensionInfoMap = new HashMap();
            ListFlexFieldValueQueryRpcParam listFlexFieldValueQueryRpcParam = new ListFlexFieldValueQueryRpcParam();
            listFlexFieldValueQueryRpcParam.setFlexFieldCode(flexFieldCode);
            ArrayList<ObjectFlexFieldValueQueryRpcParam> objectFlexFieldValueQueryRpcParams = new ArrayList<ObjectFlexFieldValueQueryRpcParam>();
            listFlexFieldValueQueryRpcParam.setParams(objectFlexFieldValueQueryRpcParams);
            List referFlexFieldCodes = referFlexFields.stream().map(v -> v.getFlexField()).collect(Collectors.toList());
            for (int i = 0; i < objs.size(); ++i) {
                T obj = objs.get(i);
                Map objectMap = BeanUtil.beanToMap(obj, (String[])new String[0]);
                HashMap extensionInfo = null;
                if (objectMap.containsKey("extensionInfo")) {
                    extensionInfo = (HashMap)objectMap.get("extensionInfo");
                }
                if (extensionInfo == null) {
                    extensionInfo = new HashMap();
                    BeanUtil.setFieldValue(obj, (String)"extensionInfo", extensionInfo);
                }
                Long idValue = i;
                objExtensionInfoMap.put(idValue, extensionInfo);
                ObjectFlexFieldValueQueryRpcParam objectFlexFieldValueQueryRpcParam = new ObjectFlexFieldValueQueryRpcParam();
                objectFlexFieldValueQueryRpcParam.setId(idValue);
                ArrayList<FlexFieldValueQueryRpcParam> flexFieldValueQueryRpcParams = new ArrayList<FlexFieldValueQueryRpcParam>();
                for (FlexFieldStructDRpcDTO referFlexField : referFlexFields) {
                    FlexFieldValueQueryRpcParam flexFieldValueQueryRpcParam = new FlexFieldValueQueryRpcParam();
                    flexFieldValueQueryRpcParam.setFlexField(referFlexField.getFlexField());
                    String referSqlCondition = referFlexField.getReferSqlCondition();
                    if (obj != null) {
                        referSqlCondition = this.handleSqlCondition(referSqlCondition, objectMap);
                    }
                    flexFieldValueQueryRpcParam.setWhereClause(referSqlCondition);
                    flexFieldValueQueryRpcParams.add(flexFieldValueQueryRpcParam);
                }
                objectFlexFieldValueQueryRpcParam.setParams(flexFieldValueQueryRpcParams);
                objectFlexFieldValueQueryRpcParams.add(objectFlexFieldValueQueryRpcParam);
            }
            ApiResult<List<ObjectFlexFieldValueRpcDTO>> apiResult = this.flexFieldRpcService.queryFlexFieldValuesList(listFlexFieldValueQueryRpcParam);
            List objectFlexFieldValueRpcDTOS = (List)apiResult.getData();
            if (CollectionUtils.isNotEmpty((Collection)objectFlexFieldValueRpcDTOS)) {
                for (ObjectFlexFieldValueRpcDTO objectFlexFieldValueRpcDTO : objectFlexFieldValueRpcDTOS) {
                    Map extensionInfo = (Map)objExtensionInfoMap.get(objectFlexFieldValueRpcDTO.getId());
                    Map<Object, Object> flexFieldValueMap = new HashMap();
                    if (CollectionUtils.isNotEmpty(objectFlexFieldValueRpcDTO.getFlexFieldValueRpcDTOS())) {
                        flexFieldValueMap = objectFlexFieldValueRpcDTO.getFlexFieldValueRpcDTOS().stream().collect(Collectors.toMap(v -> v.getFlexField(), v -> v, (o, n) -> n));
                    }
                    for (String referFlexFieldCode : referFlexFieldCodes) {
                        FlexFieldValueRpcDTO flexFieldValueRpcDTO = (FlexFieldValueRpcDTO)flexFieldValueMap.get(referFlexFieldCode);
                        if (flexFieldValueRpcDTO != null && flexFieldValueRpcDTO.getFlexFieldValue() != null) {
                            extensionInfo.put(referFlexFieldCode, flexFieldValueRpcDTO.getFlexFieldValue().toString());
                            continue;
                        }
                        extensionInfo.put(referFlexFieldCode, "");
                    }
                }
            }
        }
    }

    @Override
    public void handleFlexFieldShowName(String flexFieldCode, List<? extends CustomFieldAbstractVo> records, Function<Object, Long> idGenerator) {
        if (StringUtils.isBlank((CharSequence)flexFieldCode)) {
            throw new BusinessException("\u7ffb\u8bd1\u5f39\u6027\u57df\u663e\u793a\u540d\u79f0\u5f02\u5e38\uff0c\u5f39\u6027\u57df\u7f16\u7801\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(records)) {
            return;
        }
        if (CollectionUtils.isNotEmpty(records)) {
            FlexFieldShowNamesQueryRpcParam flexFieldShowNameQueryRpcParam = new FlexFieldShowNamesQueryRpcParam();
            flexFieldShowNameQueryRpcParam.setFlexFieldCode(flexFieldCode);
            List<FlexFieldShowNamesRpcDTO> flexFieldShowNamesRpcDTOList = records.stream().map(v -> {
                FlexFieldShowNamesRpcDTO flexFieldShowNamesRpcDTO = new FlexFieldShowNamesRpcDTO();
                try {
                    flexFieldShowNamesRpcDTO.setId(v.getId());
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
                flexFieldShowNamesRpcDTO.setExtensionInfo(v.getExtensionInfo());
                return flexFieldShowNamesRpcDTO;
            }).collect(Collectors.toList());
            flexFieldShowNameQueryRpcParam.setFlexFieldShowNamesRpcDTOList(flexFieldShowNamesRpcDTOList);
            ApiResult<Map<Long, Map<String, String>>> flexFieldShowNames = this.flexFieldRpcService.queryFlexFieldShowNames(flexFieldShowNameQueryRpcParam);
            if (flexFieldShowNames.isSuccess() && flexFieldShowNames.getData() != null && !((Map)flexFieldShowNames.getData()).isEmpty()) {
                records.stream().forEach(v -> {
                    try {
                        v.setExtensionInfo((Map)((Map)flexFieldShowNames.getData()).get(v.getId()));
                    }
                    catch (Throwable e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        }
    }

    @Override
    public void handleFlexFieldShowName(String flexFieldCode, List<? extends CustomFieldAbstractVo> records) {
        if (StringUtils.isBlank((CharSequence)flexFieldCode)) {
            throw new BusinessException("\u7ffb\u8bd1\u5f39\u6027\u57df\u663e\u793a\u540d\u79f0\u5f02\u5e38\uff0c\u5f39\u6027\u57df\u7f16\u7801\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(records)) {
            return;
        }
        if (CollectionUtils.isNotEmpty(records)) {
            FlexFieldShowNamesQueryRpcParam flexFieldShowNameQueryRpcParam = new FlexFieldShowNamesQueryRpcParam();
            flexFieldShowNameQueryRpcParam.setFlexFieldCode(flexFieldCode);
            List<FlexFieldShowNamesRpcDTO> flexFieldShowNamesRpcDTOList = records.stream().map(v -> {
                FlexFieldShowNamesRpcDTO flexFieldShowNamesRpcDTO = new FlexFieldShowNamesRpcDTO();
                try {
                    flexFieldShowNamesRpcDTO.setId(v.getId());
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
                flexFieldShowNamesRpcDTO.setExtensionInfo(v.getExtensionInfo());
                return flexFieldShowNamesRpcDTO;
            }).collect(Collectors.toList());
            flexFieldShowNameQueryRpcParam.setFlexFieldShowNamesRpcDTOList(flexFieldShowNamesRpcDTOList);
            ApiResult<Map<Long, Map<String, String>>> flexFieldShowNames = this.flexFieldRpcService.queryFlexFieldShowNames(flexFieldShowNameQueryRpcParam);
            if (flexFieldShowNames.isSuccess() && flexFieldShowNames.getData() != null && !((Map)flexFieldShowNames.getData()).isEmpty()) {
                records.stream().forEach(v -> {
                    try {
                        v.setExtensionInfo((Map)((Map)flexFieldShowNames.getData()).get(v.getId()));
                    }
                    catch (Throwable e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        }
    }

    @Override
    public <T extends CustomFieldAbstractVo> void handleSingleFlexFieldShowName(String flexFieldCode, T record) {
        if (record == null) {
            return;
        }
        ArrayList<T> records = new ArrayList<T>();
        records.add(record);
        this.handleFlexFieldShowName(flexFieldCode, records);
    }

    @Override
    public <T extends CustomFieldBaseModelVo> void handleFlexFieldShowNameForVO(String flexFieldCode, List<T> records) {
        if (StringUtils.isBlank((CharSequence)flexFieldCode)) {
            throw new BusinessException("\u7ffb\u8bd1\u5f39\u6027\u57df\u663e\u793a\u540d\u79f0\u5f02\u5e38\uff0c\u5f39\u6027\u57df\u7f16\u7801\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(records)) {
            return;
        }
        Object o = this.redisUtils.get("FLEX_FIELD_STATUS:" + flexFieldCode);
        if (!"ACTIVE".equals(o)) {
            log.info("\u5904\u7406\u503c\u4f20\u9012\uff0c\u5f53\u524d\u5f39\u6027\u57df\u672a\u542f\u7528\uff0cflexFieldCode\uff1a{}", (Object)flexFieldCode);
            return;
        }
        if (CollectionUtils.isNotEmpty(records)) {
            FlexFieldShowNamesQueryRpcParam flexFieldShowNameQueryRpcParam = new FlexFieldShowNamesQueryRpcParam();
            flexFieldShowNameQueryRpcParam.setFlexFieldCode(flexFieldCode);
            List<FlexFieldShowNamesRpcDTO> flexFieldShowNamesRpcDTOList = records.stream().map(v -> {
                FlexFieldShowNamesRpcDTO flexFieldShowNamesRpcDTO = new FlexFieldShowNamesRpcDTO();
                try {
                    flexFieldShowNamesRpcDTO.setId(v.getId());
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
                flexFieldShowNamesRpcDTO.setExtensionInfo(v.getExtensionInfo());
                return flexFieldShowNamesRpcDTO;
            }).collect(Collectors.toList());
            flexFieldShowNameQueryRpcParam.setFlexFieldShowNamesRpcDTOList(flexFieldShowNamesRpcDTOList);
            ApiResult<Map<Long, Map<String, String>>> flexFieldShowNames = this.flexFieldRpcService.queryFlexFieldShowNames(flexFieldShowNameQueryRpcParam);
            if (flexFieldShowNames.isSuccess() && flexFieldShowNames.getData() != null && !((Map)flexFieldShowNames.getData()).isEmpty()) {
                records.stream().forEach(v -> {
                    try {
                        v.setExtensionInfo((Map)((Map)flexFieldShowNames.getData()).get(v.getId()));
                    }
                    catch (Throwable e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        }
    }

    @Override
    public <T extends CustomFieldBaseModelVo> void handleSingleFlexFieldShowNameForVO(String flexFieldCode, T record) {
        if (record == null) {
            return;
        }
        ArrayList<T> records = new ArrayList<T>();
        records.add(record);
        this.handleFlexFieldShowNameForVO(flexFieldCode, records);
    }

    public String handleSqlCondition(String src, Map<String, Object> argsMap) {
        if (StringUtils.isBlank((CharSequence)src)) {
            return src;
        }
        if (argsMap == null || argsMap.isEmpty()) {
            return src;
        }
        String reg = "@[a-z|A-Z|\\d]+_?[a-z|A-Z|\\d]*@";
        Pattern pattern = Pattern.compile(reg);
        Matcher matcher = pattern.matcher(src);
        while (matcher.find()) {
            String group = matcher.group();
            String[] split = group.split("@");
            if (StringUtils.isBlank((CharSequence)split[1])) {
                return src;
            }
            Object argObj = argsMap.get(split[1]);
            if (argObj == null) {
                return src;
            }
            if (StringUtils.isBlank((CharSequence)argObj.toString())) {
                return src;
            }
            src = src.replace(group, argObj.toString());
        }
        return src;
    }
}

