package com.elitesland.support.provider.mq;

import com.elitescloud.boot.mq.common.BaseMessage;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

@Data
public class SyncMqMessage extends BaseMessage implements Serializable {
    //记录ID
    private Long entityId;
    //记录编码
    private String entityKey;
    //业务对象区分
    private String entityType;
    //外部系统类型
    private String outSysType;
    //架构防重
    private String businessKey;
    //业务数据
    String data;
    //操作类型(OperTypeEnum)
    String operType;

    @Override
    public String getBusinessKey() {
        if(StringUtils.isNotBlank(businessKey)){
            return businessKey;
        }
        return entityId.toString();
    }

    public SyncMqMessage() {}

    public SyncMqMessage(Long entityId, String entityKey, String entityType, String outSysType) {
        this.entityId = entityId;
        this.entityKey = entityKey;
        this.entityType = entityType;
        this.outSysType = outSysType;
        this.businessKey = entityKey + "@" + businessKey;
    }
    public SyncMqMessage(String entityType, String outSysType,String data) {
        this.entityType = entityType;
        this.outSysType = outSysType;
        this.businessKey = entityKey + "@" + businessKey;
        this.data = data;
    }
}
