package com.elitesland.support.provider.item.dto;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Map;

/**
 * <p>
 * 功能说明:查询商品的单位
 * </p>
 *
 * @Author Darren
 * @Date 2023/09/21
 * @Version 1.0
 * @Content:
 */
@Data
public class ItmItemUomRpcDTO implements Serializable {
    private static final long serialVersionUID = 7549237137089325466L;

    /**
     * 商品SKU的ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("商品SKU的ID")
    private Long itemId;

    /**
     * 商品SKU编号
     */
    @ApiModelProperty("商品SKU编号")
    private String itemCode;

    /**
     * 商品SKU名称
     */
    @ApiModelProperty("商品SKU名称")
    private String itemName;

    /**
     * 商品的计量单位
     */
    @ApiModelProperty(value = "商品的计量单位")
    private Map<String, String> uomMap;
}
