package com.elitesland.support.provider.item.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author brayson
 * @date 2025/11/5
 * @description
 */
@Data
@ApiModel("报检单结果")
public class ItmDeclareInspectResultSaveDTO implements Serializable {

    @ApiModelProperty(value = "ID")
    private Long id;

    @ApiModelProperty(value = "报检单号")
    private String docNo;

    @ApiModelProperty(value = "物料编码")
    private String itemCode;

    @ApiModelProperty(value = "数量")
    private String qty;

    @ApiModelProperty(value = "单位")
    private String uom;

    @ApiModelProperty(value = "批次")
    private String lotNo;

    @ApiModelProperty(value = "报检单NC单号")
    private String ncDocNo;

    @ApiModelProperty(value = "报检结果", allowableValues = "OK,PASS,QC", notes = "OK：合格品、PASS：不合格、QC：待检")
    private String result;

    @ApiModelProperty("放行处理意见")
    private String permitOpinion;

}
