package com.elitesland.support.provider.org.dto;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/10/10
 * @Version 1.0
 * @Content:
 */
@Data
@ApiModel(value = "orgUserInfoRpcDTO", description = "用户的员工、公司、组织信息出参")
public class OrgUserInfoRpcDTO implements Serializable {
    private static final long serialVersionUID = -4372680691167087298L;

    /**
     * 用户ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("用户ID")
    private Long userId;

    /**
     * 用户名
     */
    @ApiModelProperty(value = "用户名")
    private String userName;

    /**
     * 员工ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("员工ID")
    private Long empId;

    /**
     * 员工编号
     */
    @ApiModelProperty(value = "员工编号")
    private String empCode;

    /**
     * 员工名称
     */
    @ApiModelProperty(value = "员工名称")
    private String empName;

    /**
     * 所属组织ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("所属组织ID")
    private Long buId;

    /**
     * 所属组织编号
     */
    @ApiModelProperty(value = "所属组织编号")
    private String buCode;

    /**
     * 所属组织名称
     */
    @ApiModelProperty(value = "所属组织名称")
    private String buName;

    /**
     * 所属公司ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("所属公司ID")
    private Long ouId;

    /**
     * 所属公司编号
     */
    @ApiModelProperty(value = "所属公司编号")
    private String ouCode;

    /**
     * 所属公司名称
     */
    @ApiModelProperty(value = "所属公司名称")
    private String ouName;

    /**
     * 所属公司币种
     */
    @ApiModelProperty(value = "所属公司币种")
    private String currCode;

    /**
     * 所属公司的组织ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("所属公司的组织ID")
    private Long ouBuId;

    /**
     * 所属公司的组织编号
     */
    @ApiModelProperty(value = "所属公司的组织编号")
    private String ouBuCode;

    /**
     * 所属公司的组织名称
     */
    @ApiModelProperty(value = "所属公司的组织名称")
    private String ouBuName;

    /**
     * 地址薄地址号
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("地址薄地址号")
    private Long addrNo;

    /**
     * 联系人姓名
     */
    @ApiModelProperty(value = "联系人姓名")
    private String contPerson;

    /**
     * 手机号码
     */
    @ApiModelProperty(value = "手机号码")
    private String mobile;

    /**
     * 员工手机号码
     */
    @ApiModelProperty(value = "员工手机号码")
    private String empMobile;

    /**
     * 电话
     */
    @ApiModelProperty(value = "电话")
    private String tel;

    /**
     * 传真
     */
    @ApiModelProperty(value = "传真")
    private String fax;

    /**
     * 电邮
     */
    @ApiModelProperty(value = "电邮")
    private String email;
}
