package com.elitesland.support.provider.enterpriseinfo.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.support.provider.Application;
import com.elitesland.support.provider.enterpriseinfo.param.EnterpriseInfoRpcParam;
import com.elitesland.support.provider.enterpriseinfo.vo.EnterpriseInfoRpcVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Tristan
 * @date 2021/4/13
 */
@FeignClient(name = Application.NAME, path = Application.PATH + EnterpriseInfoRpcService.PATH)
@Validated
public interface EnterpriseInfoRpcService {
    String PATH = "/enterpriseInfo";

    /**
     * 新增企业信息 或者根据统一社会信用代码更新相应的是否字段 相关字段传非零即可更新
     *
     * @param param 企业信息参数
     * @return 保存结果，data中包含新增的企业信息
     */
    @PostMapping("/create")
    ApiResult<Long> createEnterpriseInfo(@RequestBody EnterpriseInfoRpcParam param);

    /**
     * 根据企业编码删除企业信息
     *
     * @param certNo 统一社会信用代码
     * @return 删除结果(软删)
     */
    @PostMapping("/delete")
    ApiResult<Void> deleteEnterpriseInfoByCertNo(@RequestParam("certNo") String certNo);

    /**
     * 更新企业信息
     *
     * @param param 企业信息参数
     * @return 更新结果，data中包含更新后的企业信息
     */
    @PostMapping("/update")
    ApiResult<Long> updateEnterpriseInfo(@RequestBody EnterpriseInfoRpcParam param);

    /**
     * 根据企业编码查询企业信息
     *
     * @param certNo 统一社会信用代码
     * @return 企业信息
     */
    @GetMapping("/get")
    ApiResult<EnterpriseInfoRpcVO> getEnterpriseInfoByCertNo(@RequestParam("certNo") String certNo);

    /**
     * 查询企业信息列表
     *
     * @param param 查询条件参数
     * @return 企业信息列表
     */
    @PostMapping("/list")
    ApiResult<List<EnterpriseInfoRpcVO>> listEnterpriseInfo(@RequestBody EnterpriseInfoRpcParam param);
}
