package com.elitesland.support.provider.enterpriseinfo.param;

import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModelVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 企业信息请求参数
 */
@Data
@ApiModel(description = "企业信息请求参数")
public class EnterpriseInfoRpcParam  extends CustomFieldBaseModelVo implements Serializable {

    @ApiModelProperty(value = "企业编码（唯一标识）")
    private String enterpriseCode;

    @ApiModelProperty(value = "企业全称")
    private String enterpriseName;

    @ApiModelProperty(value = "企业简称")
    private String enterpriseAbbr;

    @ApiModelProperty(value = "统一社会信用代码（唯一）")
    private String certNo;

    @ApiModelProperty(value = "客户标识（0-否，1-是）")
    private String custFlag;

    @ApiModelProperty(value = "供应商标识（0-否，1-是）")
    private String suppFlag;

    @ApiModelProperty(value = "公司标识（0-否，1-是）")
    private String companyFlag;

    @ApiModelProperty(value = "生产厂家标识（0-否，1-是）")
    private String producerFlag;
}