package com.elitesland.support.provider.item.service;

import com.elitesland.support.provider.Application;
import com.elitesland.support.provider.item.dto.ItmItemBomComRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemBomListRpcDTO;
import com.elitesland.support.provider.item.dto.ItmItemBomRpcDTO;
import com.elitesland.support.provider.item.param.ItmItemAsmBomRpcParam;
import com.elitesland.support.provider.item.param.ItmItemBomComRpcParam;
import com.elitesland.support.provider.item.param.ItmItemBomRpcParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;
import java.util.Map;

/**
 * @author Danny.Wang
 * @title ItmItemBomRpcService
 * @Date2023/2/28 16:58
 */
@FeignClient(name = Application.NAME, path = Application.PATH + ItmItemBomRpcService.PATH)
@Validated
public interface ItmItemBomRpcService {
    String PATH = "/itmItemBomRpc";

    /**
     * 获取商品bom信息
     * @param param
     * @return 商品bom信息
     */
    @PostMapping("/findItemBom")
    List<ItmItemBomListRpcDTO> findItemBom(@RequestBody ItmItemBomRpcParam param);

    /**
     * 根据入参查询组织匹配的商品关系的数据-单个组织
     * @param param
     * @return 商品bom信息
     */
    @PostMapping("/findItemBomBySingleBu")
    List<ItmItemBomComRpcDTO> findItemBomBySingleBu(@RequestBody ItmItemBomComRpcParam param);

    /**
     * 根据入参查询组织匹配的商品关系的数据-批量组织
     * @param param
     * @return 商品bom信息
     */
    @PostMapping("/findItemBomByBatchBu")
    List<ItmItemBomComRpcDTO> findItemBomByBatchBu(@RequestBody ItmItemBomComRpcParam param);


    @PostMapping("/isItemSubBomExist")
    Map<Long,Boolean> isItemSubBomExist(@RequestBody List<Long> itemIds);


    @PostMapping("/findItemBomBySubItemIds")
    List<ItmItemBomRpcDTO> findAsmItemBomBySubItemIds(@RequestBody ItmItemAsmBomRpcParam param);


}
