package com.elitesland.support.provider.item.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author: zhanghang
 * @create: 2022-04-28 14:40
 **/
@Data
public class ItmItemSpuRpcPagingDTO implements Serializable {
    /**
     * 记录唯一ID
     */
    @ApiModelProperty(value = "记录唯一ID")
    private Long spuId;

    /**
     * SPU编号
     */
    @ApiModelProperty(value = "SPU编号")
    private String spuCode;

    /**
     * SPU编号2
     */
    @ApiModelProperty(value = "SPU编号2")
    private String spuCode2;

    /**
     * SPU名称
     */
    @ApiModelProperty(value = "SPU名称")
    private String spuName;

    /**
     * SPU名称2
     */
    @ApiModelProperty(value = "SPU名称2")
    private String spuName2;

    /**
     * SPU简称
     */
    @ApiModelProperty(value = "SPU简称")
    private String spuAbbr;

    /**
     * 商品类型 [UDC]ITM:ITEM_TYPE
     */
    @ApiModelProperty(value = "商品类型 [UDC]yst-supp:ITEM_TYPE")
    private String itemType;

    /**
     * 物料类型 [UDC]ITM:ITEM_TYPE2
     */
    @ApiModelProperty(value = "物料类型 [UDC]ITM:ITEM_TYPE2")
    private String itemType2;

    /**
     * 商品类型3
     */
    @ApiModelProperty(value = "商品类型3")
    private String itemType3;


    /**
     * 商品类型4
     */
    @ApiModelProperty(value = "商品类型4")
    private String itemType4;

    /**
     * 商品类型4
     */
    @ApiModelProperty(value = "商品类型4")
    private String itemType5;

    /**
     * 品类编号
     */
    @ApiModelProperty(value = "品类编号")
    private String itemCateCode;

    /**
     * 商品识别号(组织编号)
     */
    @ApiModelProperty(value = "商品识别号(组织编号)")
    private String itemSource;

    /**
     * 品牌编号
     */
    @ApiModelProperty(value = "品牌编号")
    private String brand;

    /**
     * 供应商ID
     */
    @ApiModelProperty(value = "供应商ID")
    private Long suppId;

    /**
     * 供应商编号
     */
    @ApiModelProperty(value = "供应商编号")
    private String suppCode;

    /**
     * 供应商简称
     */
    @ApiModelProperty(value = "供应商简称")
    private String suppAbbr;

    /**
     * 供应商名称
     */
    @ApiModelProperty(value = "供应商名称")
    private String suppName;

    /**
     * 规格型号
     */
    @ApiModelProperty(value = "规格型号")
    private String spec;




    /**
     * 是否启用序列号
     */
    @ApiModelProperty(value = "是否启用序列号")
    private Boolean snFlag;

    /**
     * 是否启用批次号
     */
    @ApiModelProperty(value = "是否启用批次号")
    private Boolean lotFlag;

    /**
     * 效期管理标识
     */
    @ApiModelProperty(value = "效期管理标识")
    private Boolean guaranteeFlag;

    /**
     * 配货类型 [UDC]ITM:ALLOC_TYPE
     */
    @ApiModelProperty(value = "配货类型 [UDC]ITM:ALLOC_TYPE")
    private String allocType;

    /**
     * 保质期时长
     */
    @ApiModelProperty(value = "保质期时长")
    private Integer guaranteePeriod;

    /**
     * 保质期单位 [UDC]COM:TIME_UNIT
     */
    @ApiModelProperty(value = "保质期单位 [UDC]COM:TIME_UNIT")
    private String guaranteePeriodUnit;

    /**
     * 运输条件
     */
    @ApiModelProperty(value = "运输条件")
    private String transCondition;

    /**
     * 存储条件
     */
    @ApiModelProperty(value = "存储条件")
    private String storeCondition;


    // ********************* 财务参数 *********************

    /**
     * 财务分类 [UDC]ITM:FIN_TYPE
     */
    @ApiModelProperty(value = "财务分类 [UDC]ITM:FIN_TYPE")
    private String finType;

    /**
     * 成本计价/结算方法 [UDC]ITM:COST_TYPE
     */
    @ApiModelProperty(value = "成本计价/结算方法 [UDC]ITM:COST_TYPE")
    private String costType;

    /**
     * 税率编号(进项)
     */
    @ApiModelProperty(value = "税率编号(进项)")
    private String taxRateNo;

    /**
     * 税率(进项)
     */
    @ApiModelProperty(value = "税率(进项)")
    private BigDecimal taxRate;

    /**
     * 税率编号2(销项)
     */
    @ApiModelProperty(value = "税率编号2(销项)")
    private String taxRateNo2;

    /**
     * 税率(销项)
     */
    @ApiModelProperty(value = "税率(销项)")
    private BigDecimal taxRate2;

    /**
     * 关税税率，小于1的小数，保留8位，四舍五入
     */
    @ApiModelProperty(value = "关税税率，小于1的小数，保留8位，四舍五入")
    private BigDecimal taxRateTariff;


    // ********************* 服务参数 *********************

    /**
     * 是否需要安装
     */
    @ApiModelProperty(value = "是否需要安装")
    private Boolean installFlag;

    /**
     * 是否可退换货
     */
    @ApiModelProperty(value = "是否可退换货")
    private Boolean returnExchangeFlag;

    /**
     * 退换货政策 [UDC]ITM:RETURN_EXCHANGE_POLICY
     */
    @ApiModelProperty(value = "退换货政策 [UDC]ITM:RETURN_EXCHANGE_POLICY")
    private String returnExchangePolicy;

    /**
     * 是否保修
     */
    @ApiModelProperty(value = "是否保修")
    private Boolean warrantyFlag;

    /**
     * 保修期时长
     */
    @ApiModelProperty(value = "保修期时长")
    private Integer warrantyPeriod;




    /**
     * 保修期单位 [UDC]COM:TIME_UNIT
     */
    @ApiModelProperty(value = "保修期单位 [UDC]COM:TIME_UNIT")
    private String warrantyPeriodUnit;


    /**
     * es1
     */
    @ApiModelProperty("es1")
    private String es1;

    /**
     * es2
     */
    @ApiModelProperty("es2")
    private String es2;

    /**
     * es3
     */
    @ApiModelProperty("es3")
    private String es3;

    /**
     * cat2
     */
    @ApiModelProperty("cat2")
    private String cat2;



    /**
     * 原产国
     */
    @ApiModelProperty(value = "原产国")
    private String menuCountry;


    /**
     * 厂家ID
     */
    @ApiModelProperty(value = "厂家ID")
    private Long manuerId;


    /**
     * 厂家编码
     */
    @ApiModelProperty(value = "厂家编码")
    private String manuerCode;

    /**
     * 厂家名称
     */
    @ApiModelProperty(value = "厂家名称")
    private String manuerName;


    /**
     * 厂家物料编码
     */
    @ApiModelProperty(value = "厂家物料编码")
    private String manuerItemCode;

    /**
     * 商品供给来源 [UDC]yst-supp:ITEM_SUPPLY_SOURCE
     */
    @ApiModelProperty(value = "商品供给来源 [UDC]yst-supp:ITEM_SUPPLY_SOURCE")
    private String itemSupplySource;

    /**
     * 最小起定量
     */
    @ApiModelProperty(value = "最小起定量")
    private BigDecimal moq;

    /**
     * 商品规格2(1单规格 0多规格)
     */
    @ApiModelProperty(value = "商品规格2(1单规格 0多规格)")
    private String itemAttr2;

    /**
     * 采购交期(天)
     */
    @ApiModelProperty(value = "采购交期(天)")
    private Integer purDelivPeriod;

    /**
     * 税收分类码 [UDC]yst-supp:TAX_CLASS_CODE
     */
    @ApiModelProperty(value = "税收分类码 [UDC]yst-supp:TAX_CLASS_CODE")
    private String taxType;

    /**
     * 商品类别码3 [UDC]yst-supp:ITEM_CAT3
     */
    @ApiModelProperty(value = "商品类别码3 [UDC]yst-supp:ITEM_CAT3")
    private String cat3;
}
