package com.elitesland.support.provider.item.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serial;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/10/23 周四
 */
@Getter
@Setter
@ApiModel(description = "报检单创建参数")
public class ItmDeclareInspectCreateDTO implements Serializable {
    @Serial
    private static final long serialVersionUID = -5263810647721847507L;

    @ApiModelProperty("是否自动提交")
    private Boolean autoSubmit;

    @ApiModelProperty(value = "报检类型 [UDC]yst-supp:DECLARE_INSPECT_TYPE", required = true)
    private String docType;

    @ApiModelProperty(value = "公司ID", required = true)
    private Long ouId;

    @ApiModelProperty("部门ID")
    private Long buId;

    @ApiModelProperty("关联单据ID")
    private Long relatedDocId;
    @ApiModelProperty("关联单据编号")
    private String relatedDocNo;
    @ApiModelProperty("关联单据类别 [UDC]yst-supp:DOC_CLS")
    private String relateDocCls;
    @ApiModelProperty("关联单据明细ID")
    private Long relateDocDId;

    @ApiModelProperty("申请人账号ID")
    private Long applyUserId;
    @ApiModelProperty("申请人名称")
    private String applyUser;

    @ApiModelProperty(value = "申请日期", notes = "格式：yyyy-MM-dd")
    private LocalDate applyDate;

    @ApiModelProperty(value = "报检仓库ID", required = true)
    private Long whId;
    @ApiModelProperty("报检仓库编码")
    private String whCode;
    @ApiModelProperty("报检仓库名称")
    private String whName;

    @ApiModelProperty(value = "功能区编码", required = true)
    private String deter2Code;
    @ApiModelProperty("功能区名称")
    private String deter2Name;

    @ApiModelProperty(value = "商品ID", required = true)
    private Long itemId;

    @ApiModelProperty("批次ID")
    private Long lotId;
    @ApiModelProperty("批次号")
    private String lotNo;
    @ApiModelProperty("库存状态")
    private String limit1;

    @ApiModelProperty("商品批号")
    private String batchNo;

    @ApiModelProperty("生产厂家")
    private String manuFactory;
    @ApiModelProperty("生产厂家名称")
    private String manuFactoryName;

    @ApiModelProperty("批准文号")
    private String approvalNumber;

    @ApiModelProperty(value = "报检数量", required = true)
    private BigDecimal qty;

    @ApiModelProperty(value = "是否复检")
    private Boolean recheckFlag;

    @ApiModelProperty("质检附件")
    private List<String> fileCodeList;
}
