package com.elitesland.support.provider.item.dto;

import com.elitescloud.cloudt.sys.component.med.BaseModelVOMedItem;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;

@Data
@ApiModel(value = "商品简要信息", description = "商品简要信息")
public class ItmItemLotRpcDTO extends BaseModelVOMedItem implements Serializable {

    private static final long serialVersionUID = -8863745052232596865L;

    @ApiModelProperty("记录唯一ID")
    private Long id;

    @ApiModelProperty("品项编号")
    private String itemCode;

    @ApiModelProperty("品项名称")
    private String itemName;

    @ApiModelProperty("规格")
    private String spec;

    @ApiModelProperty("单位")
    private String uom;

    @ApiModelProperty("条码")
    private String barcode;

    @ApiModelProperty("商品类型")
    private String itemType;

    @ApiModelProperty(value = "是否启用批次号")
    private Boolean lotFlag;

    @ApiModelProperty(value = "是否管理批号")
    private Boolean manageLotFlag;

    @ApiModelProperty(value = "是否管理效期")
    private Boolean guaranteeFlag;

    @ApiModelProperty(value = "保质期天数")
    private Integer guaranteeDays;

    @ApiModelProperty(value = "是否管理库存")
    private Boolean manageInvFlag;

    @ApiModelProperty(value = "是否免检")
    private Boolean noCheckFlag;

    @ApiModelProperty(value = "是否管理库存状态")
    private Boolean manageInvStatusFlag;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("记录唯一ID")
    private Long spuId;

    @ApiModelProperty("品项编号")
    private String spuCode;

    /**
     * 详细描述
     */
    @ApiModelProperty(name = "详细描述")
    private String itemDescribe;

    @ApiModelProperty(name = "基本单位毛重")
    private BigDecimal grossWeight;

    @ApiModelProperty(name = "基本单位体积")
    private BigDecimal volume;

    @ApiModelProperty(name = "税率")
    private BigDecimal taxRate;

    private String taxRateNo;

    public Long fetchImageId() {
        if (Objects.equals(itemCode, spuCode)) {
            return spuId;
        }
        return id;
    }
}
