package com.elitesland.support.provider.pri.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.support.provider.pri.service.dto.PriPriceRpcDTO;
import com.elitesland.support.provider.pri.service.param.ItmPriPriceRpcDtoParam;

import java.util.List;

public interface PriPriceRpcService {

    /**
     * 获取商品价格
     *
     * 1，itemId、itemCode不能同时为空，同时有值时忽略itemId，以ItemCode进行查询，建议尽量传itemCode，可提高查询性能，避免价格中心根据itemId查询itemCode过程 <br/>
     * 2，priceType不为空时，忽略priceCls（即使有值也忽略）；priceType为空时，priceCls必填 <br/>
     * 3，uuid传值后，查询结果会将该uuid返回，可根据入参的uuid去结果集中匹配对应的查询结果 <br/>
     * 4，uom、currCode必填 <br/>
     * 5，返回值为取价集合，如果查不到价格返回空集合 <br/>
     * 6，建议批量传参取价，提高取价性能
     *
     * @param param 入参，为空返回空集合
     * @return 查询结果
     */
    ApiResult<List<PriPriceRpcDTO>> findPriPrice(List<ItmPriPriceRpcDtoParam> param);

    /**
     * 获取商品价格
     *
     * 1，itemId、itemCode不能同时为空，同时有值时忽略itemId，以ItemCode进行查询，建议尽量传itemCode，可提高查询性能，避免价格中心根据itemId查询itemCode过程 <br/>
     * 2，priceType不为空时，忽略priceCls（即使有值也忽略）；priceType为空时，priceCls必填 <br/>
     * 3，uuid传值后，查询结果会将该uuid返回，可根据入参的uuid去结果集中匹配对应的查询结果 <br/>
     * 4，uom、currCode必填 <br/>
     * 5，返回值为取价集合，如果查不到价格返回空集合 <br/>
     * 6，建议批量传参取价，提高取价性能
     *
     * @param param 入参，为空返回空集合
     * @return 查询结果
     */
    ApiResult<List<PriPriceRpcDTO>> findBusPriPrice(List<ItmPriPriceRpcDtoParam> param);
}
