package com.elitesland.support.provider.item.dto;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/10/20
 * @Version 1.0
 * @Content:
 */
@Data
@ApiModel(value = "itemConvPriceRpcDTO", description = "获取商品标准供应价的数据出参")
public class ItemConvPriceRpcDTO implements Serializable {
    private static final long serialVersionUID = 3305095427079575347L;

    /**
     * 商品id
     */
    @ApiModelProperty("商品id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    /**
     * 商品编码
     */
    @ApiModelProperty(value = "商品编码")
    private String itemCode;

    /**
     * 商品名称
     */
    @ApiModelProperty(value = "商品名称")
    private String itemName;

    /**
     * 从单位
     */
    @ApiModelProperty("从单位")
    private String fromUom;

    /**
     * 到单位
     */
    @ApiModelProperty("到单位")
    private String toUom;

    /**
     * 转换系数
     */
    @ApiModelProperty(value = "转换系数")
    private BigDecimal ratio;

    /**
     * 标准供应价
     */
    @ApiModelProperty(value = "标准供应价")
    private BigDecimal price;

    /**
     * 转换后标准供应价
     */
    @ApiModelProperty(value = "转换后标准供应价")
    private BigDecimal convPrice;

    /**
     * 采购含税价
     */
    @ApiModelProperty(value = "采购含税价")
    private BigDecimal price8;

    /**
     * 转换后采购含税价
     */
    @ApiModelProperty(value = "转换后采购含税价")
    private BigDecimal convPrice8;

    /**
     * 采购未税价
     */
    @ApiModelProperty(value = "采购未税价")
    private BigDecimal netPrice8;

    /**
     * 转换后采购未税价
     */
    @ApiModelProperty(value = "转换后采购未税价")
    private BigDecimal convNetPrice8;

    /**
     * 销售含税价
     */
    @ApiModelProperty(value = "销售含税价")
    private BigDecimal price9;

    /**
     * 转换后销售含税价
     */
    @ApiModelProperty(value = "转换后销售含税价")
    private BigDecimal convPrice9;

    /**
     * 销售未税价
     */
    @ApiModelProperty(value = "销售未税价")
    private BigDecimal netPrice9;

    /**
     * 转换后销售未税价
     */
    @ApiModelProperty(value = "转换后销售未税价")
    private BigDecimal convNetPrice9;

    /**
     * 税率编号(进项)
     */
    @ApiModelProperty(value = "税率编号(进项)")
    private String taxRateNo;

    /**
     * 税率值(进项)
     */
    private BigDecimal taxRateValue;

    /**
     * 税率编号2(销项)
     */
    @ApiModelProperty(value = "税率编号2(销项)")
    private String taxRateNo2;

    /**
     * 税率值2(销项)
     */
    private BigDecimal taxRateValue2;
}
