package com.elitesland.support.provider.item.dto;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitescloud.cloudt.sys.component.med.BaseModelVOMedItem;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
@ApiModel(value = "商品简要信息", description = "商品简要信息")
public class ItmItemSimpleRpcDTO extends BaseModelVOMedItem implements Serializable {

    private static final long serialVersionUID = -8863745052232596865L;

    @ApiModelProperty("记录唯一ID")
    private Long id;

    @ApiModelProperty("品项编号")
    private String itemCode;

    @ApiModelProperty("品项名称")
    private String itemName;

    @ApiModelProperty("规格")
    private String spec;

    @ApiModelProperty("单位")
    private String uom;

    @ApiModelProperty("商品类型")
    private String itemType;

    @ApiModelProperty("商品分类编码")
    private String itemCateCode;

    @ApiModelProperty("分类名称")
    private String itemCateName;

    @ApiModelProperty("分类名称")
    private String itemCateFullName;

    @ApiModelProperty("品牌")
    private String brandName;

    @ApiModelProperty("品牌编码")
    private String brand;

    @ApiModelProperty(value = "最小起定量")
    private BigDecimal moq;

    @ApiModelProperty(value = "采购含税价")
    private BigDecimal price8;

    @ApiModelProperty(value = "供应价")
    private BigDecimal price;

    @ApiModelProperty(value = "保留小数位")
    private Integer decimalPlaces;

    @ApiModelProperty("辅助单位")
    private String uom2;

    @ApiModelProperty("领用单位")
    private String receiveUom;

    @ApiModelProperty(value = "拆零包装")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String disassemblyPack;
    @ApiModelProperty(value = "拆零包装名称")
    private String disassemblyPackName;


    @ApiModelProperty(value = "单位转换率")
    private BigDecimal uomRatio2;

    @ApiModelProperty("税率(进项)")
    private BigDecimal taxRate;

    @ApiModelProperty("税率2(销项)")
    private BigDecimal taxRate2;

    private String taxRateNo2;

    private String taxRateNo;

    @ApiModelProperty("领用单位转换率")
    private BigDecimal receiveUomRatio;

    @ApiModelProperty("包装规格")
    private String packageSpec;

    private String itemType2;

    private String itemSupplySource;

    @ApiModelProperty("是否启用批次")
    private Boolean lotFlag;

    @ApiModelProperty("配货模式")
    private String allocType;

    @ApiModelProperty(value = "保质期时长")
    private Integer guaranteePeriod;

    /**
     * 保质期单位 [UDC]COM:TIME_UNIT
     */
    @ApiModelProperty(value = "保质期单位 [UDC]COM:TIME_UNIT")
    private String guaranteePeriodUnit;

    @ApiModelProperty(value = "供应商编码")
    private String suppCode;

    @ApiModelProperty(value = "供应商名称")
    private String suppName;

    @ApiModelProperty(value = "保鲜期")
    private Integer freshDays;

    @ApiModelProperty(value = "提前预警期")
    private Integer preWarnDays;
}
