package com.elitesland.support.provider.pri.service.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * 配件三包配置 - 分页查询参数
 *
 * @author : elvis.hong
 * @date 2023/03/03 16:22
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(description = "配件三包配置分页查询参数")
public class ItmWarrantyConfigRpcQueryParam implements Serializable {

    @ApiModelProperty("商品ID")
    private Long itemId;

    @ApiModelProperty("配件类型")
    private String itemType3;

    @ApiModelProperty("商品编码/名称")
    private String itemCodeName;

    @ApiModelProperty("ERP编码/名称")
    private String itemCodeName2;

    @ApiModelProperty("商品ID")
    private List<Long> itemIds;

    @ApiModelProperty("商品编码")
    private List<String> itemCodes;
}
