package com.elitesland.support.provider.item.dto;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author brayson
 * @date 2025/11/5
 * @description
 */
@Data
@ApiModel("报检单详情")
public class ItmDeclareInspectDetailRpcDTO implements Serializable {

    @ApiModelProperty(value = "ID")
    private Long id;

    @ApiModelProperty(value = "报检单号", notes = "系统自动生成")
    private String docNo;

    @ApiModelProperty(value = "报检类型 [UDC]yst-supp:DECLARE_INSPECT_TYPE", required = true)
    @SysCode(sys = "yst-supp", mod = "DECLARE_INSPECT_TYPE")
    private String docType;
    private String docTypeName;

    @ApiModelProperty("报检状态 [UDC]yst-supp:DECLARE_INSPECT_STATUS")
    @SysCode(sys = "yst-supp", mod = "DECLARE_INSPECT_STATUS")
    private String docStatus;
    private String docStatusName;

    @ApiModelProperty(value = "公司ID", required = true)
    private Long ouId;
    @ApiModelProperty("公司编码")
    private String ouCode;
    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("关联单据ID")
    private Long relatedDocId;
    @ApiModelProperty("关联单据类别 [UDC]yst-supp:DOC_CLS")
    @SysCode(sys = "yst-supp", mod = "DOC_CLS")
    private String relateDocCls;
    private String relateDocClsName;
    @ApiModelProperty("关联单据编号")
    private String relatedDocNo;
    @ApiModelProperty("关联单据明细ID")
    private Long relateDocDId;

    @ApiModelProperty("申请人账号ID")
    private Long applyUserId;
    @ApiModelProperty("申请人名称")
    private String applyUser;

    @ApiModelProperty(value = "申请日期", notes = "格式：yyyy-MM-dd")
    private LocalDate applyDate;

    @ApiModelProperty(value = "报检仓库ID")
    private Long whId;
    @ApiModelProperty("报检仓库编码")
    private String whCode;
    @ApiModelProperty("报检仓库名称")
    private String whName;

    @ApiModelProperty("功能区编码")
    private String deter2Code;
    @ApiModelProperty("功能区名称")
    private String deter2Name;

    @ApiModelProperty(value = "商品ID", required = true)
    private Long itemId;
    @ApiModelProperty("商品编码")
    private String itemCode;
    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("规格型号")
    private String spec;

    @ApiModelProperty("基本单位, [UDC]yst-supp:UOM")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom;
    private String uomName;

    @ApiModelProperty("批次ID")
    private Long lotId;
    @ApiModelProperty("批次号")
    private String lotNo;
    @ApiModelProperty("库存状态")
    private String limit1;

    @ApiModelProperty("商品批号")
    private String batchNo;

    @ApiModelProperty("生产厂家")
    private String manuFactory;
    @ApiModelProperty("生产厂家名称")
    private String manuFactoryName;

    @ApiModelProperty("批准文号")
    private String approvalNumber;

    @ApiModelProperty(value = "报检数量", required = true)
    private BigDecimal qty;

    @ApiModelProperty(value = "是否复检")
    private Boolean recheckFlag;

    @ApiModelProperty("NC报检单号")
    private String ncDocNo;

    @ApiModelProperty("检验结果状态")
    private String inspectResult;

    @ApiModelProperty("放行处理意见")
    private String permitOpinion;

    @ApiModelProperty("库存状态变更单号")
    private String invApplyDocNo;

    @ApiModelProperty("创建人")
    private String creator;
    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createTime;
    @ApiModelProperty("更新人")
    private String updater;
    @ApiModelProperty(value = "修改时间")
    private LocalDateTime modifyTime;

    @ApiModelProperty("质检附件")
    private List<ItmDeclareInspectFileRpcDTO> fileList;

}
