package com.elitesland.support.provider.item.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * @author Chris
 * @date 2021-04-27
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel("商品DTO查询参数")
public class ItmItemRpcDtoParam implements Serializable {

    /**
     * 商品SKU ID列表
     */
    @ApiModelProperty("商品SKU ID列表")
    private List<Long> itemIds;

    /**
     * 商品SPU ID列表
     */
    @ApiModelProperty("商品SPU ID列表")
    private List<Long> spuIds;

    /**
     * 商品SPU编码列表
     */
    @ApiModelProperty("商品SPU编码列表")
    private List<String> spuCodes;

    /**
     * 商品SPU名称
     */
    @ApiModelProperty("商品SPU名称")
    private String spuName;

    /**
     * 商品SPU名称
     */
    @ApiModelProperty("商品SPU名称/编码 模糊查询")
    private String spuNameCode;

    /**
     * 商品SPU名称2
     */
    @ApiModelProperty("商品SPU名称2")
    private String spuName2;

    @ApiModelProperty("商品标配")
    private String itemGroup2;

    /**
     * 商品SKU编号列表
     */
    @ApiModelProperty("商品SKU编号列表")
    private List<String> itemCodes;

    /**
     * 商品名称/编码 模糊查询
     */
    @ApiModelProperty("商品名称/编码 模糊查询")
    private String itemNameCode;

    /**
     * 规格型号列表
     */
    @ApiModelProperty("规格型号列表")
    private List<String> specs;

    /**
     * 商品品牌编号列表
     */
    @ApiModelProperty("商品品牌编号列表")
    private List<String> brands;

    /**
     * 供应商编码列表
     */
    @ApiModelProperty("供应商编码列表")
    private List<String> suppCodes;

    /**
     * 品类编号
     */
    @ApiModelProperty("品类编号")
    private String itemCateCode;
    @ApiModelProperty(value = "品类编号集合")
    private List<String> itemCateCodes;

    /**
     * 商品类型 [UDC]ITM:ITEM_TYPE
     */
    @ApiModelProperty("商品类型 [UDC]yst-supp:ITEM_TYPE")
    private String itemType;

    /**
     * 物料类型 [UDC]ITM:ITEM_TYPE2
     */
    @ApiModelProperty("物料类型 [UDC]ITM:ITEM_TYPE2")
    private String itemType2;

    /**
     * 物料类型 [UDC]ITM:ITEM_TYPE2
     */
    @ApiModelProperty("物料类型 [UDC]ITM:ITEM_TYPE2")
    private List<String> itemType2s;

    /**
     * 商品类型3 [UDC]yst-supp:ITEM_TYPE3
     */
    @ApiModelProperty("商品类型3 [UDC]yst-supp:ITEM_TYPE3")
    private String itemType3;

    /**
     * 商品类型3 [UDC]yst-supp:ITEM_TYPE3
     */
    @ApiModelProperty("商品类型3 [UDC]yst-supp:ITEM_TYPE3")
    private List<String> itemType3s;

    /**
     * 商品类型4 [UDC]yst-supp:ITEM_TYPE4
     */
    @ApiModelProperty("商品类型4 [UDC]yst-supp:ITEM_TYPE4")
    private String itemType4;

    /**
     * 商品类型5 [UDC]yst-supp:ITEM_TYPE5
     */
    @ApiModelProperty("商品类型5 [UDC]yst-supp:ITEM_TYPE5")
    private String itemType5;

    /**
     * 商品SKU状态 [UDC]ITM:ITEM_STATUS
     */
    @ApiModelProperty("商品SKU状态 [UDC]ITM:ITEM_STATUS")
    private String itemStatus;

    /**
     * 配货类型 [UDC]ITM:ALLOC_TYPE
     */
    @ApiModelProperty("配货类型 [UDC]ITM:ALLOC_TYPE")
    private String allocType;

    /**
     * 商品来源组织列表
     */
    @ApiModelProperty("商品来源组织列表")
    private List<String> itemSources;


    /**
     * 商品SPU编码2列表
     */
    @ApiModelProperty("商品SPU编码2列表")
    private List<String> spuCode2s;

    @ApiModelProperty(value = "产地")
    private String origin;

    @ApiModelProperty(value = "商品启用状态（如果需要查询所有状态传:ALL）")
    private String itemStatus3;

    /**
     * 商品供给来源 [UDC]yst-supp:ITEM_SUPPLY_SOURCE
     */
    @ApiModelProperty(value = "商品供给来源 [UDC]yst-supp:ITEM_SUPPLY_SOURCE")
    private String itemSupplySource;

    /**
     * 商品类别码3 [UDC]yst-supp:ITEM_CAT3
     */
    @ApiModelProperty(value = "商品类别码3 [UDC]yst-supp:ITEM_CAT3")
    private String cat3;

    /**
     * 商品规格2(1单规格 0多规格)
     */
    @ApiModelProperty(value = "商品规格2(1单规格 0多规格)")
    private String itemAttr2;

    /**
     * 采购交期(天)
     */
    @ApiModelProperty(value = "采购交期(天)")
    private Integer purDelivPeriod;

    /**
     * 税收分类码 [UDC]yst-supp:TAX_CLASS_CODE
     */
    @ApiModelProperty(value = "税收分类码 [UDC]yst-supp:TAX_CLASS_CODE")
    private String taxType;

    /**
     * 商品SKU状态
     */
    @ApiModelProperty(value = "商品SKU状态")
    private List<String> itemStatus2List;

    /**
     * 是否过滤临时组套商品(true 过滤，false 不过滤) 默认不过滤
     */
    @ApiModelProperty(value = "是否过滤临时组套商品(true 过滤，false 不过滤)")
    public Boolean filtTempComItem = false;

    @ApiModelProperty(value = "是否首营")
    private Boolean subFlag;
}
