package com.elitesland.support.provider.pri.service.dto;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 配件三包配置 - 分页查询返回参数
 *
 * @author : elvis.hong
 * @date 2023/03/03 16:22
 */
@Data
@ApiModel(description = "配件三包配置分页查询返回参数")
public class ItmWarrantyConfigRpcDTO implements Serializable {

    @ApiModelProperty("记录唯一ID")
    private Long id;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

    @ApiModelProperty("ERP编码")
    private String itemCode2;

    @ApiModelProperty("ERP名称")
    private String itemName2;

    @ApiModelProperty("商品类型3")
    @SysCode(sys = "yst-supp", mod = "ITEM_TYPE3")
    private String itemType3;
    private String itemType3Name;

    @ApiModelProperty("消费者三包期")
    private BigDecimal consumerWarrantyTime;

    @ApiModelProperty("消费者三包期日期单位 Y-年 M-月")
    private String consumerWarrantyTimeUom;

    @ApiModelProperty("经销商三包期")
    private BigDecimal dealerWarrantyTime;

    @ApiModelProperty("经销商三包期日期单位 Y-年 M-月")
    private String dealerWarrantyTimeUom;

    @ApiModelProperty("三包内容")
    private String warrantyContent;

    @ApiModelProperty("非三包项")
    private String warrantyExcluded;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("记录创建者ID")
    private Long createUserId;

    @ApiModelProperty("记录创建者")
    private String creator;

    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty("记录最后更新者ID")
    private Long modifyUserId;

    @ApiModelProperty("记录最后更新者")
    private String updater;

    @ApiModelProperty("记录最后更新时间")
    private LocalDateTime modifyTime;

    @ApiModelProperty("数据归属组织id")
    private Long secBuId;

    @ApiModelProperty("数据归属雇员id")
    private Long secUserId;

    @ApiModelProperty("数据归属公司id")
    private Long secOuId;

}
