package com.elitesland.support.provider.org.param;

import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModelVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author Chris
 * @date 2021-03-10
 */
@Data
public class OrgQualifyReviewDRpcParam extends CustomFieldBaseModelVo implements Serializable {

    private static final long serialVersionUID = -4556831321181172717L;

    @ApiModelProperty("id")
    private Long id;
    @ApiModelProperty("masId")
    private Long masId;
    @ApiModelProperty("来源编码")
    private String origCode;

    @ApiModelProperty(value = "临时编码（保存没有提交审核的编码）")
    private String codeTemp;
    @ApiModelProperty("来源")
    private String dataSource;

    /**
     * 资质文件名称
     */
    @ApiModelProperty(value = "资质文件名称")
    private String qualifyFileName;

    /**
     * 资质文件编号(上传后系统生成的编号)
     */
    @ApiModelProperty(value = "资质文件编号(上传后系统生成的编号)")
    private String qualifyFileCode;

    @ApiModelProperty("证照正面照片url")
    private String frontPicUrl;
    @ApiModelProperty("证照反面照片url")
    private String backPicUrl;
    @ApiModelProperty("证照图片url")
    private String picUrl;
    @ApiModelProperty("证照正面照片文件编码")
    private String frontPicFileCode;
    @ApiModelProperty("证照反面照片文件编码")
    private String backPicFileCode;
    @ApiModelProperty("证照图片文件编码")
    private String picFileCode;
}
