package com.elitesland.support.provider.item.dto;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;


@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "ThaliItemNewDtlReplaceRpcDTO", description = "规格组子件替换商品数据")
public class ThaliItemNewDtlReplaceRpcDTO implements Serializable {

    @ApiModelProperty("Id")
    private Long id;

    @ApiModelProperty("菜品id")
    private Long masId;

    @ApiModelProperty("子件id")
    private Long subId;

    @ApiModelProperty("子件商品id")
    private Long itemId;
    @ApiModelProperty("子件商品编码")
    private String itemCode;

    @ApiModelProperty("替换商品id")
    private Long replaceItemId;
    @ApiModelProperty("替换商品编码")
    private String replaceItemCode;
    @ApiModelProperty("替换商品名称")
    private String replaceItemName;

    @ApiModelProperty("优先级")
    private Integer priority;
    @ApiModelProperty("替换商品单位 [UDC]yst-supp:UOM")
    private String replaceUom;
    @ApiModelProperty("替换商品数量")
    private BigDecimal replaceQty;

    @ApiModelProperty("领用单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String receiveUom;
    private String receiveUomName;

    @ApiModelProperty(value = "领用单位转换系数")
    private BigDecimal receiveUomRatio;
}
