package com.elitesland.support.provider.org.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Set;

/**
 * 区域查询参数.
 *
 * @author Kaiser（wang shao）
 * @date 2024/8/19
 */
@Getter
@Setter
@ApiModel(description = "区域查询参数")
public class OrgRegionQueryDTO implements Serializable {
    private static final long serialVersionUID = 4640056286177874336L;

    @ApiModelProperty(value = "区域编码")
    private String regionCode;
    @ApiModelProperty(value = "区域编码")
    private Set<String> regionCodes;

    @ApiModelProperty(value = "启用状态")
    private Boolean enabled;

    @ApiModelProperty(value = "适用对象，[UDC]yst-supp:REGION_USE_AT")
    private String applicableObj;

    @ApiModelProperty(value = "适用属性")
    private String applicableAttr;

    @ApiModelProperty(value = "上级组织编码")
    private String parentOrgCode;

    @ApiModelProperty(value = "备用字段1")
    private String bs1;

    @ApiModelProperty(value = "备用字段2")
    private String bs2;

    @ApiModelProperty(value = "匹配的国家编码")
    private String countryCode;

    @ApiModelProperty(value = "匹配的省份编码")
    private String provinceCode;

    @ApiModelProperty(value = "匹配的市编码")
    private String cityCode;

    @ApiModelProperty(value = "匹配的县编码")
    private String countyCode;
}
