package com.elitesland.support.provider.org.param.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
@ApiModel("地址信息")
public class OuAddress implements Serializable {
    private static final long serialVersionUID = 7763248833151483512L;

    @ApiModelProperty(value = "地址类型",
        notes = "1、DEFAULT：默认地址；2、OTHER：其他；3、RECEIVE：收货地址")
    private String addressType;

    @ApiModelProperty(value = "是否默认地址",
        notes = "1是，0否")
    private String defaultFlag;

    @ApiModelProperty(value = "联系人")
    private String contPerson;

    @ApiModelProperty(value = "手机")
    private String mobile;

    @ApiModelProperty(value = "电话")
    private String tel;

    @ApiModelProperty(value = "省市区编码")
    private String areaCode;

    @ApiModelProperty(value = "详细地址")
    private String detailAddr;

    @ApiModelProperty(value = "国家")
    private String country;

    @ApiModelProperty(value = "电邮")
    private String email;
}
    