package com.elitesland.support.provider.org.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.support.provider.Application;
import com.elitesland.support.provider.org.dto.OrgFranchiseeSyncRpcDTO;
import com.elitesland.support.provider.org.param.OrgFranchiseeDtoParam;
import com.elitesland.support.provider.org.param.OrgFranchiseeRpcParam;
import com.elitesland.support.provider.org.param.OrgFranchiseeSyncParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@FeignClient(name = Application.NAME, path = Application.PATH + OrgFranchiseeRpcService.PATH)
@Validated
public interface OrgFranchiseeRpcService {
    String PATH = "/orgFranchiseRpc";
    /**
     * 新增或者更新加盟商信息
     * @param param
     * @return String
     */
    @GetMapping("/franchiseeSaveAndUpdate")
    @ApiOperation("新增或者更新加盟商信息")
    ApiResult<String> franchiseeSaveAndUpdate(@RequestBody OrgFranchiseeDtoParam param);

    /**
     * 查询待同步加盟商信息
     * @param param
     * @return String
     */
    @GetMapping("/findSyncFranchisee")
    @ApiOperation("查询待同步加盟商信息")
    ApiResult<List<OrgFranchiseeSyncRpcDTO>> findSyncFranchisee(@RequestBody OrgFranchiseeRpcParam param);

    /**
     * 更新加盟商更新状态
     * @param param
     * @return
     */
    @GetMapping("/updateSyncStatus")
    ApiResult<Void> updateSyncStatus(@RequestBody List<OrgFranchiseeSyncParam> param);
}
