package com.elitesland.support.provider.item.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author zhiyu.he
 * @date 2025/11/21 9:38
 */
@Data
public class ItmItemQueryCateDTO implements Serializable {


    @ApiModelProperty(value = "品类编码")
    private String itemCateCode;

    /**
     * 品类名称
     */
    @ApiModelProperty(value = "品类名称")
    private String itemCateName;

    /**
     * 是否基础类目（0：不是，1：是）
     */
    @ApiModelProperty(value = "是否基础类目（0：不是，1：是）")
    private Integer itemCateIsBasic;

    /**
     * 状态
     */
    @ApiModelProperty(value = "状态")
    private String status;

    /**
     * 品类描述
     */
    @ApiModelProperty(value = "品类描述")
    private String itemCateDesc;

    @ApiModelProperty(value = "品类标识（不同客户端）")
    private String itemCateMark;

    @ApiModelProperty(value = "是否应用菜品（0：不是，1：是）")
    private Integer whetherApplyItem;


    @ApiModelProperty(value = "税收分类码 [UDC]yst-supp:TAX_CLASS_CODE")
    private String taxType;


    //private String itemCatePath;

    @ApiModelProperty("全名")
    private String itemCateFullName;
}
