package com.elitesland.support.provider.storeConfirmation.service;

import com.elitesland.support.provider.Application;
import com.elitesland.support.provider.storeConfirmation.dto.StoreConfirmationRpcVO;
import com.elitesland.support.provider.thaliItem.service.ThaliItemRpcService;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 *
 * Created by lance on 2025/11/10.
 */
@FeignClient(name = Application.NAME, path = Application.PATH + ThaliItemRpcService.PATH)
@Validated
public interface StoreConfirmationRpcService {

    String PATH = "/storeConfirmation";

    @PostMapping("/getStoreConfirmation")
    List<StoreConfirmationRpcVO> getStoreConfirmation(@RequestParam("storeCodeList") List<String> storeCodeList, @RequestParam("type") String type);
}
