package com.elitesland.support.provider.item.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * <p>
 * 品类属性key RPC 查询返回param
 * </p>
 *
 * @author ssy
 * @since 2023/8/14
 */
@Data
@ApiModel("品类属性key RPC 查询返回param")
public class ItmCatePropRpcDTO implements Serializable {

    private static final long serialVersionUID = 7537395874820294582L;

    @ApiModelProperty("ID")
    private Long id;

    @ApiModelProperty(value = "品类编码")
    private String itemCateCode;

    @ApiModelProperty(value = "属性名编码")
    private String catePropCode;

    @ApiModelProperty(value = "属性名名称")
    private String catePropName;

    @ApiModelProperty(value = "属性类型 [UDC]ITM:CATE_PROP_TYPE")
    private String catePropType;
    private String catePropTypeName;

    @ApiModelProperty(value = "排序号")
    private Integer sortNo;
}
