package com.elitesland.support.provider.item.param;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 品类属性key RPC 查询param
 * </p>
 *
 * @author ssy
 * @since 2023/8/14
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel("品类属性keyRPC查询参数")
public class ItmCatePropRpcQueryParam extends AbstractOrderQueryParam implements Serializable {

    private static final long serialVersionUID = -4793859899818738365L;

    @ApiModelProperty(value = "品类编码集合")
    private List<String> itemCateCodes;

    @ApiModelProperty(value = "属性名称/编码，支持模糊查询")
    private String propCodeName;

    @ApiModelProperty(value = "属性类型 [UDC]ITM:CATE_PROP_TYPE")
    private String catePropType;

    /**
     * 单选复选(0:单选,1:复选)
     */
    @ApiModelProperty(value = "单选复选(0:单选,1:复选)")
    private Integer isBox;

    /**
     * 录入方式(0:列表选择,1:手动输入)
     */
    @ApiModelProperty(value = "录入方式(0:列表选择,1:手动输入)")
    private Integer isHand;

    /**
     * 是否必填(0:否,1:是)
     */
    @ApiModelProperty(value = "是否必填(0:否,1:是)")
    private Integer isMust;


    @ApiModelProperty(value = "自定义属性(0:否,1:是)")
    private Integer isCust;


    @ApiModelProperty(value = "用于检索(0:否,1:是)")
    private Integer isSearch;

    /**
     * 是否和SKU相关(0:否,1:是)
     */
    @ApiModelProperty(value = "是否和SKU相关(0:否,1:是)")
    private Integer isSku;

}
