package com.elitesland.support.provider.item.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.support.provider.Application;
import com.elitesland.support.provider.item.dto.ItmCatePropRpcDTO;
import com.elitesland.support.provider.item.param.ItmCatePropRpcQueryParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;


/**
 * <p>
 * 品类属性key RPC 服务
 * </p>
 *
 * @author ssy
 * @since 2023/8/14
 */
@FeignClient(name = Application.NAME, path = Application.PATH + ItmCatePropRpcService.PATH)
@Validated
public interface ItmCatePropRpcService {
    String PATH = "/itmCatePropRpc";


    /**
     * 获取 品类属性key 列表
     *    注： getOrders 为空，则默认排序为：orderNo asc，cate_prop_code desc
     * @param param dto 查询条件
     * @return dto
     */
    @PostMapping("/findItmCatePropRpcDto")
    List<ItmCatePropRpcDTO> findItmCatePropRpcDtoByParam(@RequestBody ItmCatePropRpcQueryParam param);

    /**
     * 获取 品类属性key 分页
     *    注： getOrders 为空，则默认排序为：orderNo asc，cate_prop_code desc
     * @param param dto 查询条件
     * @return dto
     */
    @PostMapping("/findItmCatePropRpcDtoPaging")
    PagingVO<ItmCatePropRpcDTO> findItmCatePropRpcDtoPagingByParam(@RequestBody ItmCatePropRpcQueryParam param);

}
