package com.elitesland.support.provider.org.service;

import com.elitesland.support.provider.Application;
import com.elitesland.support.provider.org.dto.OrgStoreDetailRpcDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@FeignClient(name = Application.NAME, path = Application.PATH + OrgStoreRpcService.PATH)
@Validated
public interface OrgStoreRpcService {
    String PATH = "/orgStoreRpc";

    @GetMapping("/{id}")
    OrgStoreDetailRpcDTO get(@PathVariable("id") Long id);

    @GetMapping("/getByCode")
    OrgStoreDetailRpcDTO getByCode(@RequestParam("storeCode") String storeCode);

    @PostMapping("/queryByIds")
    List<OrgStoreDetailRpcDTO> queryByIds(@RequestBody List<Long> ids);

    @PostMapping("/queryByStoreCodes")
    List<OrgStoreDetailRpcDTO> queryByStoreCodes(@RequestBody List<String> storeCodes);

    @GetMapping("/getStoreCodesByCustCode")
    List<String> getStoreCodesByCustCode(@RequestParam("custCode") String custCode);
}
