package com.elitesland.support.provider.item.dto;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.support.provider.item.dto
 * @date 2023/7/31 10:41
 */
@Data
@ApiModel("商品BOM集合详情")
public class ItmItemBomListRpcDTO implements Serializable {

    /**
     * 商品ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("商品ID")
    private Long itemId;

    /**
     * SKU商品编号
     */
    @ApiModelProperty(value = "SKU商品编号")
    private String itemCode;

    /**
     * SKU商品名称
     */
    @ApiModelProperty(value = "SKU商品名称")
    private String itemName;

    /**
     * 是否启用批次
     */
    @ApiModelProperty(value = "是否启用批次")
    private Boolean lotFlag;

    /**
     * 主计量单位
     */
    @SysCode(sys = "yst-supp", mod = "UOM")
    @ApiModelProperty("主计量单位 [UDC]COM:UOM")
    private String uom;
    private String uomName;

    /**
     * SKU商品规格
     */
    @ApiModelProperty(value = "SKU商品规格")
    private String spec;

    @ApiModelProperty(value = "保质期天数")
    private Integer guaranteeDays;

    @ApiModelProperty("品牌")
    private String brand;
    @ApiModelProperty("品牌名称")
    private String brandName;

    /**
     * 该商品下面的子集BOM集合
     */
    @ApiModelProperty(value = "该商品下面的子集BOM集合")
    List<ItmItemBomRpcDTO> itmItemBomDTOS;


}
