package com.elitesland.support.provider.item.dto;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Tristan
 * @date 2021/3/1
 */
@Data
@ApiModel(value = "商品主表采购中心反参", description = "商品主表采购中心反参")
public class ItmItemPoDTO implements Serializable {

    private static final long serialVersionUID = 6692024955033074078L;

    /**
     * 品项id
     */
    @ApiModelProperty("品项id")
    private Long id;

    /**
     * 品项编号
     */
    @ApiModelProperty("品项编号")
    private String itemCode;

    /**
     * 品项名称
     */
    @ApiModelProperty("品项名称")
    private String itemName;

    /**
     * 税率 进项VAT
     */
    @ApiModelProperty("税率 进项VAT")
    BigDecimal taxRate;

    /**
     * 代理商
     */
    @ApiModelProperty("代理商")
    String agency;

    /**
     * 品牌
     */
    @ApiModelProperty("品牌")
    String brand;

    /**
     * 效期管理标识
     */
    @ApiModelProperty("效期管理标识")
    private Boolean guaranteeFlag;

    /**
     * 保质期时长
     */
    @ApiModelProperty("保质期时长")
    private Integer guaranteePeriod;

    /**
     * 保质期单位 [UDC]ITM:GUARANTEE_PERIOD_UNIT
     */
    @ApiModelProperty("保质期单位 [UDC]ITM:GUARANTEE_PERIOD_UNIT")
    private String guaranteePeriodUnit;

    /**
     * 保质期天数
     */
    @ApiModelProperty("保质期天数")
    private Integer guaranteeDays;

    /**
     * 基本计量单位
     */
    @ApiModelProperty("基本计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom;
    private String uomName;

    /**
     * 辅助计量单位
     */
    @ApiModelProperty("辅助计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom2;
    private String uom2Name;

    /**
     * 中包装计量单位
     */
    @ApiModelProperty("中包装计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom3;
    private String uom3Name;

    /**
     * 大包装计量单位
     */
    @ApiModelProperty("大包装计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom4;
    private String uom4Name;

    /**
     * 计量单位5
     */
    @ApiModelProperty("计量单位5")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom5;
    private String uom5Name;

    /**
     * 税率索引 进项
     */
    @ApiModelProperty("税率索引 进项")
    @SysCode(sys = "yst-supp", mod = "TAX_RATE_INDEX")
    String taxRateIndex;
    String taxRateIndexName;

    /**
     * 条码
     */
    @ApiModelProperty("条码")
    private String barCode;

    /**
     * 品项简称
     */
    @ApiModelProperty("品项简称")
    private String itemAbbr;

    /**
     * 默认采购单位
     */
    @ApiModelProperty("默认采购单位")
    private String purcUom;
}
