package com.elitesland.support.provider.item.param;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author: zhanghang
 * @create: 2022-04-28 15:06
 **/
@Data
@EqualsAndHashCode(callSuper=false)
public class ItmItemSpuRpcPagingParam extends AbstractOrderQueryParam{
    private static final long serialVersionUID = -1959538967478010520L;
    /**
     * spu编码
     */
    @ApiModelProperty(value = "spu编码")
    private String spuCode;

    /**
     * spu名称
     */
    @ApiModelProperty(value = "spu名称")
    private String spuName;

    /**
     * spu名称2
     */
    @ApiModelProperty(value = "spu名称2")
    private String spuName2;

    /**
     * 规格型号
     */
    @ApiModelProperty("规格型号")
    private String spce;

    /**
     * 商品来源组织
     */
    @ApiModelProperty("商品来源组织")
    private String itemSource;

    /**
     * 商品供给来源 [UDC]yst-supp:ITEM_SUPPLY_SOURCE
     */
    @ApiModelProperty(value = "商品供给来源 [UDC]yst-supp:ITEM_SUPPLY_SOURCE")
    private String itemSupplySource;

    /**
     * 商品规格2(1单规格 0多规格)
     */
    @ApiModelProperty(value = "商品规格2(1单规格 0多规格)")
    private String itemAttr2;

    /**
     * 采购交期(天)
     */
    @ApiModelProperty(value = "采购交期(天)")
    private Integer purDelivPeriod;

    /**
     * 税收分类码 [UDC]yst-supp:TAX_CLASS_CODE
     */
    @ApiModelProperty(value = "税收分类码 [UDC]yst-supp:TAX_CLASS_CODE")
    private String taxType;

    /**
     * 商品类别码3 [UDC]yst-supp:ITEM_CAT3
     */
    @ApiModelProperty(value = "商品类别码3 [UDC]yst-supp:ITEM_CAT3")
    private String cat3;

    /**
     * 商品SKU状态
     */
    @ApiModelProperty(value = "商品SKU状态")
    private List<String> itemStatus2List;
}
