package com.elitesland.support.provider.item.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author : Scott.zhang(zhang hang)
 * @Date : 2021/12/2116:24
 */
@Data
public class ItmItemUomConvCalcParam implements Serializable {
    private static final long serialVersionUID = -4286693234192653476L;

    /**
     * 商品id
     */
    @NotNull(message = "商品id不能为空")
    @ApiModelProperty("商品id")
    private Long itemId;

    /**
     * 业务单位
     */
    @NotNull(message = "业务单位不能为空")
    @ApiModelProperty("业务单位（主单位/非主单位）")
    private String businessUom;

    /**
     * 转换数据
     */
    @NotNull(message = "转换数量不能为空")
    @ApiModelProperty("需要转换的数量")
    private BigDecimal convertNum;

}
