package com.elitesland.support.provider.path.dto;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Tristan
 * @date 2021/3/10
 */
@Data
@ApiModel("结算路径")
public class SupportTransactionPathDRpcDTO implements Serializable {

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "Id")
    private Long id;

    @ApiModelProperty(value = "主表id")
    private Long masId;

    @ApiModelProperty(value = "行号")
    private Integer lineNo;

    @ApiModelProperty(value = "从公司id")
    private Long companyIdStart;

    @ApiModelProperty(value = "至公司id")
    private Long companyIdEnd;

    @ApiModelProperty(value = "从公司编码")
    private String companyCodeStart;

    @ApiModelProperty(value = "至公司编码")
    private String companyCodeEnd;

    @ApiModelProperty(value = "从公司名称")
    private String companyNameStart;

    @ApiModelProperty(value = "至公司名称")
    private String companyNameEnd;

    @ApiModelProperty(value = "从供应商id")
    private Long suppIdStart;

    @ApiModelProperty(value = "从供应商code")
    private String suppCodeStart;

    @ApiModelProperty(value = "从供应商name")
    private String suppNameStart;

    @ApiModelProperty(value = "至客户id")
    private Long custIdEnd;

    @ApiModelProperty(value = "至客户code")
    private String custCodeEnd;

    @ApiModelProperty(value = "至客户名称")
    private String custNameEnd;

    @ApiModelProperty(value = "从越库仓id")
    private Long whIdStart;

    @ApiModelProperty(value = "从越库仓编码")
    private String whCodeStart;

    @ApiModelProperty(value = "从越库仓名称")
    private String whNameStart;

    @ApiModelProperty(value = "至越库仓id")
    private Long whIdEnd;

    @ApiModelProperty(value = "至越库仓编码")
    private String whCodeEnd;

    @ApiModelProperty(value = "至越库仓名称")
    private String whNameEnd;

    @ApiModelProperty(value = "从功能区编码")
    private String deter2CodeStart;

    @ApiModelProperty(value = "至功能区编码")
    private String deter2CodeEnd;

    @ApiModelProperty(value = "从功能区名称")
    private String deter2NameStart;

    @ApiModelProperty(value = "至功能区名称")
    private String deter2NameEnd;

}
