package com.elitesland.support.provider.path.dto;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Tristan
 * @date 2021/3/10
 */
@Data
@ApiModel("计算路径明细")
public class SupportTransactionPathRpcDTO implements Serializable {

    private static final long serialVersionUID = -60151055238354033L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "Id")
    private Long id;

    @ApiModelProperty(value = "'路径编码")
    private String pathCode;

    @ApiModelProperty(value = "路径名称")
    private String pathName;

    @ApiModelProperty(value = "从公司id")
    private Long companyIdStart;

    @ApiModelProperty(value = "至公司id")
    private Long companyIdEnd;

    @ApiModelProperty(value = "从公司编码")
    private String companyCodeStart;

    @ApiModelProperty(value = "至公司编码")
    private String companyCodeEnd;

    @ApiModelProperty(value = "从公司名称")
    private String companyNameStart;

    @ApiModelProperty(value = "至公司名称")
    private String companyNameEnd;

    @ApiModelProperty(value = "有效期从")
    private LocalDateTime validFrom;

    @ApiModelProperty(value = "有效期至")
    private LocalDateTime validTo;

    @ApiModelProperty(value = "状态")
    @SysCode(sys = "yst-supp",mod = "PATH_STATUS")
    private String pathStatus;
    private String pathStatusName;

    @ApiModelProperty(value = "标识正逆向")
    private Boolean flag;

    private List<SupportTransactionPathDRpcDTO> detailList;
}
