package com.elitesland.support.provider.item.dto;

import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class ThaliItemDDTO implements Serializable {
    private static final long serialVersionUID = -8237009724434364020L;

    @ApiModelProperty("组套id")
    private Long masId;

    @ApiModelProperty("行号")
    private int lineNo;

    @ApiModelProperty("子件商品id")
    private Long itemId;

    @ApiModelProperty("子件商品编码")
    private String itemCode;

    @ApiModelProperty("子件商品名称")
    private String itemName;

    @ApiModelProperty("子件商品分类")
    private String itemCateCode;

    @ApiModelProperty("子件商品分类名称")
    private String itemCateName;

    @ApiModelProperty("规格型号")
    private String spec;

    @ApiModelProperty("计量单位")
    private String uom;

    @ApiModelProperty("计量单位")
    private String uomName;

    @ApiModelProperty("子件数量")
    private BigDecimal qty;

    @ApiModelProperty("经销价格 明细经销单价")
    private BigDecimal retailPrice;

    @ApiModelProperty("组套价 明细组套单价")
    private BigDecimal thaliPrice;

    @ApiModelProperty("是否默认套件")
    private Boolean def;

    @ApiModelProperty("明细组套方式")
    private String itemThaliType;

    @ApiModelProperty("明细组套方式")
    private String itemThaliTypeName;

    @ApiModelProperty("经销价汇总")
    public BigDecimal getTotalRetailPrice() {
        if (retailPrice == null || qty == null) {
            return BigDecimal.ZERO;
        }

        return qty.multiply(retailPrice);
    }

    @ApiModelProperty("组套价汇总")
    public BigDecimal getTotalThaliPrice() {
        if (thaliPrice == null || qty == null) {
            return BigDecimal.ZERO;
        }

        return qty.multiply(thaliPrice);
    }
}
