package com.elitesland.support.provider.item.dto;


import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class ThaliItemDTO implements Serializable {
    private static final long serialVersionUID = -8237009724434364020L;

    @ApiModelProperty("组套ID")
    private String thaliNo;

    @ApiModelProperty("组套商品编码")
    private String thaliItemCode;

    @ApiModelProperty("组套商品名称")
    private String thaliItemName;

    @ApiModelProperty("组套价格 明细组套价格总和")
    private BigDecimal thaliItemPrice;

    @ApiModelProperty("经销价格 明细经销价总和")
    private BigDecimal retailPrice;

    @ApiModelProperty("状态")
    private String docStatus;

    @ApiModelProperty("状态")
    private String docStatusName;

    @ApiModelProperty("审批状态")
    private String apprStatus;

    @ApiModelProperty("审批状态")
    private String apprStatusName;

    @ApiModelProperty("审批时间")
    private LocalDateTime apprTime;

    @ApiModelProperty("审批人ID")
    private Long apprUserId;

    @ApiModelProperty("审批意见")
    private String apprComment;

    @ApiModelProperty("创建组织id")
    private Long ouId;

    @ApiModelProperty("创建组织编码")
    private String ouCode;

    @ApiModelProperty("创建组织名称")
    private String ouName;

    @ApiModelProperty("定价方式")
    private String priceType;

    @ApiModelProperty("定价方式")
    private String priceTypeName;

    @ApiModelProperty("套餐类型")
    private String thaliType;

    @ApiModelProperty("定价方式")
    private String thaliTypeName;

    @ApiModelProperty("启用禁用状态")
    private String itemStatus;

    @ApiModelProperty("启用禁用状态")
    private String itemStatusName;

    /**
     * 工作流字段
     */
    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty(value = "提交时间")
    private LocalDateTime submitTime;

    @ApiModelProperty(value = "审批通过时间")
    private LocalDateTime approvedTime;

    @ApiModelProperty("子件集合")
    private List<ThaliItemDDTO> thaliItemDVOS;


}
