package com.elitesland.support.provider.org.vo;

import com.elitesland.support.provider.org.dto.OrgAddrDetailsRpcDTO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Tristan
 * @date 2021/4/8
 */
@Data
@ApiModel(description = "员工明细信息")
public class OrgEmpDetailDTO implements Serializable {
    private static final long serialVersionUID = 3454293733330494357L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("记录唯一ID")
    private Long id;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "所属BU ID")
    private Long buId;

    /**
     * 所属BU名称
     */
    @ApiModelProperty("所属BU名称")
    private String buName;

    /**
     * 所属BU编号
     */
    @ApiModelProperty("所属BU编号")
    private String buCode;

    /**
     * 雇员编号
     */
    @ApiModelProperty("雇员编号")
    private String empCode;

    /**
     * 雇员姓名
     */
    @ApiModelProperty("雇员姓名")
    private String empName;

    /**
     * 员工性别 [UDC]ORG:EMP_GENDER
     */
    @ApiModelProperty("员工性别 [UDC]ORG:EMP_GENDER")
    private String empGender;

    /**
     * 出生日期
     */
    @ApiModelProperty("出生日期")
    private LocalDateTime birthDate;

    /**
     * 证件类型 [UDC]ORG:EMP_ID_TYPE
     */
    @ApiModelProperty("证件类型 [UDC]ORG:EMP_ID_TYPE")
    private String idType;

    /**
     * 证件号码
     */
    @ApiModelProperty("证件号码")
    private String idNo;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "用户ID")
    private Long userId;

    /**
     * 用户名称
     */
    @ApiModelProperty("用户名称")
    private String userName;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "地址号")
    private Long addrNo;

    /**
     * 地址簿参数
     */
    @ApiModelProperty("地址簿参数")
    private OrgAddrDetailsRpcDTO orgAddrDetailVO;
}
