package com.elitesland.support.provider.price.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author Chris
 * @date 2021-06-13
 */
@Data
@ApiModel("商品主档价格RPC DTO")
public class PriMainPriceRpcDTO implements Serializable {

    private static final long serialVersionUID = 4330266788295608035L;

    @ApiModelProperty("价格唯一标识ID")
    private Long id;

    @ApiModelProperty(value = "商品ID")
    private Long itemId;

    @ApiModelProperty("品项编号")
    private String itemCode;

    @ApiModelProperty(value = "市场价")
    private BigDecimal price1;

    @ApiModelProperty(value = "B端指导价")
    private BigDecimal price2;

    @ApiModelProperty(value = "C端零售价")
    private BigDecimal price3;

    @ApiModelProperty(value = "B端毛利控制率")
    private BigDecimal price4;

    @ApiModelProperty(value = "C端毛利控制率")
    private BigDecimal price5;

    @ApiModelProperty(value = "B端毛利率")
    private BigDecimal price6;

    @ApiModelProperty(value = "C端毛利率")
    private BigDecimal price7;

    @ApiModelProperty(value = "采购价")
    private BigDecimal price8;

    @ApiModelProperty(value = "币种")
    private String currCode;

    @ApiModelProperty(value = "生效时间")
    private LocalDateTime validFrom;

    @ApiModelProperty(value = "失效时间")
    private LocalDateTime validTo;

    @ApiModelProperty(value = "状态")
    private String priceStatus;
}
