package com.elitesland.support.provider.org.param;

import com.elitesland.support.provider.org.RpcBaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;

/**
 * DTO for {@link com.elitesland.support.core.domain.entity.org.OrgContactDO}
 */
@Data
@ApiModel("联系人")
public class OrgContactSaveRpcParam extends RpcBaseModel implements DataHash {
    @ApiModelProperty("关联主表ID")

    private Long masId;


    @ApiModelProperty("联系人类型")

    private String type;


    @ApiModelProperty("联系人姓名")

    private String name;


    @ApiModelProperty("联系人身份证号")

    private String idCardNo;

    @ApiModelProperty("身份证有效期开始日")

    private LocalDate idCardValidFrom;

    @ApiModelProperty("身份证有效期截止日")

    private LocalDate idCardValidTo;


    @ApiModelProperty("联系人手机号")

    private String mobile;

    @ApiModelProperty("地址编号")

    private Long addrNo;

    @ApiModelProperty("身份证照片正面")

    private String idCardFrontCode;

    @ApiModelProperty("身份证照片正面url")

    private String idCardFrontUrl;

    @ApiModelProperty("身份证照片反面")

    private String idCardBackCode;

    @ApiModelProperty("身份证照片反面url")

    private String idCardBackUrl;

    @ApiModelProperty("状态，ACTIVE：启用，CLOSED：停用")

    private String status;

    @ApiModelProperty("省市区地址")
    private String address;

    @ApiModelProperty("详细地址")
    private String detailAddress;


    /**
     * 省份
     */
    @ApiModelProperty(value = "省份")
    private String province;

    /**
     * 城市
     */
    @ApiModelProperty(value = "城市")
    private String city;

    /**
     * 区县
     */
    @ApiModelProperty(value = "区县")
    private String county;


    @ApiModelProperty(value = "正式表ID")
    private Long oldId;

    @Override
    public Object[] waitHashContent() {
        return new Object[]{this.getId()};
    }
}