package com.elitesland.support.provider.path;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.support.provider.Application;
import com.elitesland.support.provider.path.dto.SupportTransactionPathRpcDTO;
import com.elitesland.support.provider.path.param.SupportTransactionPathRpcParam;
import com.elitesland.support.provider.path.param.SupportTransactionPathRpcSaveParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Tristan
 * @date 2021/4/13
 */
@FeignClient(name = Application.NAME, path = Application.PATH + SupportTransactionPathRpcService.PATH)
@Validated
public interface SupportTransactionPathRpcService {


    String PATH = "rpc/support/transaction/path";


    /**
     * 根据编码查询启用状态的结算路径
     * @param pathCode
     * @return
     */
    @GetMapping("/getByPathCode")
    ApiResult<SupportTransactionPathRpcDTO> getByPathCode(@RequestParam("pathCode") String pathCode);


    /**
     * 查询启用状态的结算路径
     * @param rpcParam
     * @return
     */
    @PostMapping("/query")
    ApiResult<SupportTransactionPathRpcDTO> queryByParam(@RequestBody SupportTransactionPathRpcParam rpcParam);

    @PostMapping("/list")
    ApiResult<List<SupportTransactionPathRpcDTO>> queryListByParam(@RequestBody List<SupportTransactionPathRpcParam> rpcParams);

    @PostMapping("/create")
    ApiResult<String> create(@RequestBody List<SupportTransactionPathRpcSaveParam> rpcParams);
}
