package com.elitesland.support.provider.org.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.support.provider.Application;
import com.elitesland.support.provider.org.dto.OrgAddrDetailsRpcDTO;
import com.elitesland.support.provider.org.dto.OrgAddressRpcDTO;
import com.elitesland.support.provider.org.dto.OrgBankAccRpcDTO;
import com.elitesland.support.provider.org.dto.OrgOuBankAccRpcDTO;
import com.elitesland.support.provider.org.param.*;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Tristan
 * @date 2021/4/13
 */
@FeignClient(name = Application.NAME, path = Application.PATH + OrgAddrRpcService.PATH)
@Validated
public interface OrgAddrRpcService {
    String PATH = "/orgAddrRpc";
    /**
     * 新增或修改地址薄信息
     * <p>
     * 该接口用于创建或者编辑现有的地址薄信息，所有的子信息为全删全插操作
     * 如果使用该接口，则请不要使用创建组织的接口，否则会创建两个地址薄信息
     * 该接口判断传入的ID是否为null来决定是新增还是编辑，返回的结果是地址号 addrNo，而不是ID
     * <p>
     * 如果接口调用失败，ApiResult 中的 data 返回将为 null，success 为 false，错误信息会保存在 message 中
     *
     * @param param 参数
     * @return 调用结果，如果成功，data 中保存的是 addrNo，而不是id
     */
    @PostMapping("/orgAddrSaveOrUpdateReturnAddrNo")
    ApiResult<Long> orgAddrSaveOrUpdateReturnAddrNo(@RequestBody OrgAddrRpcSaveParam param);


    @PostMapping("/orgAddrAddressSaveOrUpdate")
    @ApiModelProperty("地址簿-地址信息新增更新")
    ApiResult<Long> orgAddrAddressSaveOrUpdate(@RequestBody OrgAddrAddressRpcSaveParam param);

    @GetMapping("/orgAddrAddressDelete/{id}")
    @ApiModelProperty("地址簿-地址信息删除  id为地址信息的主键id")
    void orgAddrAddressDelete(@PathVariable("id") Long id);

    /**
     * 供应商更新银行信息中的第三方虚拟用户ID与第三方虚拟帐户
     * <p>
     * 必须提供的参数：地址号addrNo、账户类型accType、账号bankAcc、公司编码 ouCcde
     *
     * @param param 参数
     */
    @PutMapping("/orgAddrUpdateThirdparty")
    void orgAddrUpdateThirdpartyByParam(@RequestBody OrgAddrUpdateThirdpartyByParam param);

    /**
     * 根据 param 获取地址薄详情
     *
     * @param param param
     * @return 地址薄详情
     */
    @PostMapping("/findRpcDto")
    ApiResult<OrgAddrDetailsRpcDTO> findRpcDtoByParam(@RequestBody OrgAddrQueryRpcParam param);

    /**
     * 软删除地址薄信息
     *
     * @param addrNo 地址号
     */
    @DeleteMapping("/softDeleteOrgAddrByAddrNo")
    void softDeleteOrgAddrByAddrNo(@RequestParam(name = "addrNo") Long addrNo);

    /**
     * 获取地址薄-地址信息列表，该接口一般应用与如下场景
     * 1. 第三方通过查询获取一些基本信息，用于后端处理
     * 2. 检查数据是否存在，存在则会返回数据，不存在则不会返回数据
     * <p>
     * 如果传入的查询参数均为空，则不返回任何数据，防止获取全部数据
     * <p>
     * 注意接口返回数据没有上限控制，请合理使用，保证效能
     * 该接口在服务端配置 timeout 时间为 5s
     * 如果遇到 timeout 问题，请和开发协调沟通进行优化
     *
     * @param param dto 查询条件，每个条件使用 and 关联
     * @return dto
     */
    @PostMapping("/findAddrAddressRpcDto")
    List<OrgAddressRpcDTO> findAddrAddressRpcDtoByParam(@RequestBody OrgAddressRpcDtoParam param);

    /**
     * 获取地址薄-银行信息列表，该接口一般应用与如下场景
     * 1. 第三方通过查询获取一些基本信息，用于后端处理
     * 2. 检查数据是否存在，存在则会返回数据，不存在则不会返回数据
     * <p>
     * 如果传入的查询参数均为空，则不返回任何数据，防止获取全部数据
     * <p>
     * 注意接口返回数据没有上限控制，请合理使用，保证效能
     * 该接口在服务端配置 timeout 时间为 5s
     * 如果遇到 timeout 问题，请和开发协调沟通进行优化
     *
     * @param param dto 查询条件，每个条件使用 and 关联
     * @return dto
     */
    @PostMapping("/findBankAccRpcDto")
    List<OrgBankAccRpcDTO> findBankAccRpcDtoByParam(@RequestBody OrgBankAccRpcDtoParam param);

    /**
     * 逻辑删除 地址薄-联系人信息
     *
     * @param param
     */
    @DeleteMapping("/softUpdateOrgAddrAddress")
    void softUpdateOrgAddrAddressByParam(@RequestBody OrgSoftUpdateAddressParam param);

    /**
     * 新增修改联系人
     *
     * @param params
     */
    @PostMapping("/orgAddrAddressDetailsSaveOrUpdate")
    void orgAddrAddressDetailsSaveOrUpdate(@RequestBody List<OrgAddrAddressRpcUpdateParam> params);

    /**
     * 简单查询地址信息
     * @param param
     * @return
     */
    @PostMapping("/findSimpleAddrAddress")
    List<OrgAddressRpcDTO> findSimpleAddrAddressByParam(@RequestBody OrgAddressRpcDtoParam param);

    /**
     * 公司账户信息
     * @param param 参数
     * @return 结果
     */
    @PostMapping("/findOuBankByParam")
    List<OrgOuBankAccRpcDTO> findOuBankByParam(@RequestBody OrgBankAccQueryRpcParam param);
}
