package com.elitesland.support.provider.item.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

/**
 * @author jeesie
 * @description:
 * @datetime 2025年 06月 23日 13:43
 * @version: 1.0
 */
@Data
public class ItmItemSuppRegionRpcDtoParam implements Serializable {

    @ApiModelProperty("商品列表")
    @NotNull(message = "商品列表不能为空")
    @Size(min = 1, message = "至少选择一个商品")
    private List<String> itemCodes;

    @ApiModelProperty("国家")
    private String country;

    @ApiModelProperty("省份")
    @NotBlank(message = "省份不能为空")
    private String province;

    @ApiModelProperty("城市")
    @NotBlank(message = "城市不能为空")
    private String city;

    @ApiModelProperty("区县")
    @NotBlank(message = "区县不能为空")
    private String county;

    @ApiModelProperty("是否支持直送")
    @NotBlank(message = "是否支持直送buneng")
    private Boolean directDelivery;

}
