package com.elitesland.support.provider.item.service;

import com.elitesland.support.provider.Application;
import com.elitesland.support.provider.item.dto.ItmBrandRpcDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author Rikyon
 * @date 2025-7-29
 */
@FeignClient(name = Application.NAME, path = Application.PATH + ItmBrandRpcService.PATH)
@Validated
public interface ItemRecvAddressRpcService {
    String PATH = "/ItemRecvAddressRpc";
    /**
     * 根据门店id返回是否存在可用门店联系人
     */
    @PostMapping("/hasAddress")
    Boolean hasAddress(@RequestBody String param);
}

