package com.elitesland.support.provider.org.dto;

import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModelVo;
import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author chaofeng.xia
 * @since 2025/7/7
 */
@Data
public class OrgOuBankAccRpcDTO extends CustomFieldBaseModelVo implements Serializable {

    private static final long serialVersionUID = -912899669074704062L;

    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    private Long ouId;

    /**
     * 公司编码
     */
    @ApiModelProperty("公司编码")
    private String ouCode;

    /**
     * 账号类型:[UDC]ORG:ADDR_BANKACC_TYPE
     */
    @ApiModelProperty(value = "账号类型:[UDC]ORG:ADDR_BANKACC_TYPE")
    @SysCode(sys = "yst-supp", mod = "ADDR_BANKACC_TYPE")
    private String accType;
    @ApiModelProperty(value = "账号类型名称")
    private String accTypeName;

    /**
     * 开户行账号
     */
    @ApiModelProperty(value = "开户行账号")
    private String bankAcc;

    /**
     * 开户人姓名
     */
    @ApiModelProperty(value = "开户人姓名")
    private String holderName;

    /**
     * 结算人身份证号
     */
    @ApiModelProperty("结算人身份证号")
    private String idCardNo;

    /**
     * 地址号
     */
    @ApiModelProperty(value = "地址号")
    private Long addrNo;

    @ApiModelProperty("状态，ACTIVE：启用，CLOSED：停用")
    @SysCode(sys = "yst-supp", mod = "ORG_BANK_STATUS")
    private String status;
    private String statusName;
}
