package com.elitesland.support.provider.org.dto;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author Chris
 * @date 2021-04-28
 */
@Data
@ApiModel("员工DTO信息")
public class OrgEmpRpcDTO implements Serializable {

    private static final long serialVersionUID = -5732779613146247708L;

    /**
     * 员工ID
     */
    @ApiModelProperty("员工ID")
    private Long id;

    /**
     * 雇员编号
     */
    @ApiModelProperty("雇员编号")
    private String empCode;

    /**
     * 雇员姓名
     */
    @ApiModelProperty("雇员姓名")
    private String empName;

    /**
     * 员工类型 [UDC]ORG:EMP_TYPE
     */
    @ApiModelProperty("员工类型 [UDC]ORG:EMP_TYPE")
    private String empType;
    private String empTypeName;

    /**
     * 员工状态 [UDC]ORG:EMP_STATUS
     */
    @ApiModelProperty("员工状态 [UDC]ORG:EMP_STATUS")
    private String empStatus;

    /**
     * 所属组织ID
     */
    @ApiModelProperty("所属组织ID")
    private Long buId;

    /**
     * 所属组织编号
     */
    @ApiModelProperty("所属组织编号")
    private String buCode;

    /**
     * 所属组织名称
     */
    @ApiModelProperty("所属组织名称")
    private String buName;

    /**
     * 所属公司编码
     */
    @ApiModelProperty("所属公司编码")
    private String OuCode;

    /**
     * 所属公司名称
     */
    @ApiModelProperty("所属公司名称")
    private String OuName;

    /**
     * 用户ID
     */
    @ApiModelProperty("用户ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long userId;

    /**
     * 用户名
     */
    @ApiModelProperty("用户名")
    private String userName;

    /**
     * 地址号
     */
    @ApiModelProperty("地址号")
    private Long addrNo;

    /**
     * 工作手机号
     */
    @ApiModelProperty("工作手机号")
    private String mobile;

    /**
     * 父id
     */
    @ApiModelProperty("父id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long pid;


    /**
     * 父用户ID
     */
    @ApiModelProperty("父用户ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long pidUserId;

    /**
     * 父用户名称
     */
    @ApiModelProperty("父用户名称")
    private String pidUserName;




}
