package com.elitesland.support.provider.item.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * @author Chris
 * @date 2021-04-27
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel("商品单位转换DTO查询条件")
public class ItmItemUomConvRpcDtoParam implements Serializable {

    private static final long serialVersionUID = 6366854372521014195L;

    /**
     * 商品SKU ID列表
     */
    @ApiModelProperty("商品SKU ID列表")
    private List<Long> itemIds;

    /**
     * 商品code列表
     */
    @ApiModelProperty("商品code列表")
    private List<String> itemCodes;

    /**
     * 从单位
     */
    @ApiModelProperty("从单位")
    private String fromUom;

    /**
     * 到单位
     */
    @ApiModelProperty("到单位")
    private String toUom;

    /**
     * 根据商品id、从单位、到单位批量查询转换系数
     */
    @ApiModelProperty(value = "根据商品id、从单位、到单位批量查询转换系数")
    private List<ItmItemUomConvRpcOtherParam> otherParam;
}
