package com.elitesland.support.provider.item.service;


import com.elitesland.support.provider.Application;
import com.elitesland.support.provider.item.dto.ItmItemBomToNCRPCDTO;
import com.elitesland.support.provider.item.dto.ItmItemPublishToNCRPCDTO;
import com.elitesland.support.provider.item.param.ItmItemBomToNCRpcParam;
import com.elitesland.support.provider.item.param.ItmItemToNCRPCParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@FeignClient(name = Application.NAME, path = Application.PATH + ItmItemPublishToNcRpcService.PATH)
@Validated
public interface ItmItemPublishToNcRpcService {

    String PATH = "/publishToNC";


    @PostMapping("/getToNCItem")
    List<ItmItemPublishToNCRPCDTO> getToNCItem(@RequestBody ItmItemToNCRPCParam param);




    @PostMapping("/getToNCBom")
    List<ItmItemBomToNCRPCDTO> getToNCBom(@RequestBody ItmItemBomToNCRpcParam param);


}
