package com.elitesland.support.provider.org.dto;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author Chris
 * @date 2021-03-10
 */
@Data
@ApiModel("地址薄DTO")
public class OrgAddrDetailsRpcDTO implements Serializable {

    private static final long serialVersionUID = -6599089817915217899L;

    /**
     * ID
     */
    @ApiModelProperty("ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    /**
     * 地址号
     */
    @ApiModelProperty("地址号")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long addrNo;

    /**
     * 地址薄类型:[UDC]ORG:ADDR_TYPE
     */
    @ApiModelProperty("地址薄类型:[UDC]ORG:ADDR_TYPE")
    @SysCode(sys = "yst-supp", mod = "ADDR_TYPE")
    private String addrType;
    @ApiModelProperty(value = "地址薄类型名称")
    private String addrTypeName;

    /**
     * 地址薄名称
     */
    @ApiModelProperty("地址薄名称")
    private String addrName;

    /**
     * 统一信用代码
     */
    @ApiModelProperty("统一信用代码")
    private String uniCertNo;

    @ApiModelProperty(value = "ES1")
    private String es1;

    /**
     * ES2
     */
    @ApiModelProperty(value = "ES2")
    private String es2;

    /**
     * ES3
     */
    @ApiModelProperty(value = "ES3")
    private String es3;

    /**
     * 地址信息列表
     */
    @ApiModelProperty("地址信息列表")
    List<OrgAddrAddressRpcDTO> orgAddrAddressVos;

    /**
     * 银行信息列表
     */
    @ApiModelProperty("银行信息列表")
    List<OrgAddrBankAccRpcDTO> orgAddrBankAccVos;

    /**
     * 证照信息列表
     */
    @ApiModelProperty("证照信息列表")
    List<OrgAddrQualifyRpcDTO> orgAddrQualifyVos;

}
